/*
 * Decompiled with CFR 0.152.
 */
package net.jami.datastore.main;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.jami.datastore.dao.ContactDao;
import net.jami.datastore.dao.ConversationDao;
import net.jami.datastore.dao.ConversationRequestDao;
import net.jami.datastore.dao.DeviceDao;
import net.jami.datastore.dao.GroupDao;
import net.jami.datastore.dao.PolicyDao;
import net.jami.datastore.dao.SystemDao;
import net.jami.datastore.dao.UserDao;
import net.jami.datastore.dao.UserGroupMappingsDao;
import net.jami.datastore.dao.UserProfileDao;
import net.jami.jams.common.authentication.AuthenticationSource;
import net.jami.jams.common.authentication.AuthenticationSourceInfo;
import net.jami.jams.common.authentication.AuthenticationSourceType;
import net.jami.jams.common.dao.connectivity.ConnectionPool;
import net.jami.jams.common.objects.user.User;
import net.jami.jams.common.objects.user.UserProfile;
import net.jami.jams.common.utils.X509Utils;
import org.flywaydb.core.Flyway;

public class DataStore
implements AuthenticationSource {
    public static ConnectionPool connectionPool;
    private UserDao userDao;
    private GroupDao groupDao;
    private PolicyDao policyDao;
    private DeviceDao deviceDao;
    private SystemDao systemDao;
    private ContactDao contactDao;
    private ConversationDao conversationDao;
    private ConversationRequestDao conversationRequestDao;
    private UserProfileDao userProfileDao;
    private UserGroupMappingsDao userGroupMappingsDao;
    public static final Integer RESULTS_PER_PAGE;
    public static Integer NUM_PAGES;

    public DataStore(String connectionString) {
        Flyway flyway = Flyway.configure().dataSource(connectionString, "", "").load();
        flyway.migrate();
        connectionPool = new ConnectionPool(connectionString);
        this.userDao = new UserDao();
        this.groupDao = new GroupDao();
        this.policyDao = new PolicyDao();
        this.deviceDao = new DeviceDao();
        this.systemDao = new SystemDao();
        this.contactDao = new ContactDao();
        this.conversationDao = new ConversationDao();
        this.conversationRequestDao = new ConversationRequestDao();
        this.userProfileDao = new UserProfileDao();
        this.userGroupMappingsDao = new UserGroupMappingsDao();
    }

    public boolean createUser(User user) {
        return this.userDao.storeObject(user);
    }

    public List<UserProfile> searchUserProfiles(String queryString, String field, Optional<Integer> page) {
        List<UserProfile> userList;
        if (queryString.equals("*")) {
            userList = this.userProfileDao.getAllUserProfile();
        } else if (field.equals("LOGON_NAME")) {
            userList = this.userProfileDao.searchUsername(queryString);
        } else if (field.equals("FULL_TEXT_NAME")) {
            userList = this.userProfileDao.searchFullName(queryString);
        } else {
            throw new IllegalArgumentException("Invalid field");
        }
        if (userList == null) {
            userList = new ArrayList<UserProfile>();
        }
        NUM_PAGES = Integer.valueOf(userList.size()) / RESULTS_PER_PAGE;
        if (userList.size() % RESULTS_PER_PAGE != 0) {
            Integer n = NUM_PAGES;
            Integer n2 = NUM_PAGES = Integer.valueOf(NUM_PAGES + 1);
        }
        if (page.isPresent() && !userList.isEmpty()) {
            userList = userList.size() < RESULTS_PER_PAGE ? userList.subList(0, userList.size()) : (page.get() * RESULTS_PER_PAGE > userList.size() ? userList.subList((page.get() - 1) * RESULTS_PER_PAGE, userList.size()) : userList.subList((page.get() - 1) * RESULTS_PER_PAGE, page.get() * RESULTS_PER_PAGE));
        }
        return userList;
    }

    public UserProfile getUserProfile(String username) {
        return this.userProfileDao.getByUsername(username).orElse(null);
    }

    public boolean setUserProfile(UserProfile userProfile) {
        return this.userProfileDao.storeObject(userProfile);
    }

    public boolean updateUserProfile(UserProfile userProfile) {
        return this.userProfileDao.updateUserProfile(userProfile);
    }

    public boolean updateUserCertificate(User user) {
        return this.userDao.updateUserCertificate(user.getUsername(), X509Utils.getPEMStringFromCertificate((X509Certificate)user.getCertificate()));
    }

    public boolean authenticate(String username, String password) {
        return this.userDao.getByUsername(username).map(user -> user.getPassword()).orElse("").equals(password);
    }

    public AuthenticationSourceInfo getInfo() {
        return new AuthenticationSourceInfo("LOCAL", AuthenticationSourceType.LOCAL);
    }

    public boolean test() {
        return true;
    }

    public boolean updatePassword(User user, String password) {
        return false;
    }

    public UserDao getUserDao() {
        return this.userDao;
    }

    public GroupDao getGroupDao() {
        return this.groupDao;
    }

    public PolicyDao getPolicyDao() {
        return this.policyDao;
    }

    public DeviceDao getDeviceDao() {
        return this.deviceDao;
    }

    public SystemDao getSystemDao() {
        return this.systemDao;
    }

    public ContactDao getContactDao() {
        return this.contactDao;
    }

    public ConversationDao getConversationDao() {
        return this.conversationDao;
    }

    public ConversationRequestDao getConversationRequestDao() {
        return this.conversationRequestDao;
    }

    public UserProfileDao getUserProfileDao() {
        return this.userProfileDao;
    }

    public UserGroupMappingsDao getUserGroupMappingsDao() {
        return this.userGroupMappingsDao;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    public void setGroupDao(GroupDao groupDao) {
        this.groupDao = groupDao;
    }

    public void setPolicyDao(PolicyDao policyDao) {
        this.policyDao = policyDao;
    }

    public void setDeviceDao(DeviceDao deviceDao) {
        this.deviceDao = deviceDao;
    }

    public void setSystemDao(SystemDao systemDao) {
        this.systemDao = systemDao;
    }

    public void setContactDao(ContactDao contactDao) {
        this.contactDao = contactDao;
    }

    public void setConversationDao(ConversationDao conversationDao) {
        this.conversationDao = conversationDao;
    }

    public void setConversationRequestDao(ConversationRequestDao conversationRequestDao) {
        this.conversationRequestDao = conversationRequestDao;
    }

    public void setUserProfileDao(UserProfileDao userProfileDao) {
        this.userProfileDao = userProfileDao;
    }

    public void setUserGroupMappingsDao(UserGroupMappingsDao userGroupMappingsDao) {
        this.userGroupMappingsDao = userGroupMappingsDao;
    }

    static {
        RESULTS_PER_PAGE = 24;
    }
}

