/*
 * Decompiled with CFR 0.152.
 */
package net.jami.datastore.dao;

import java.sql.PreparedStatement;
import java.util.List;
import net.jami.datastore.dao.AbstractDao;
import net.jami.datastore.main.DataStore;
import net.jami.jams.common.dao.connectivity.SQLConnection;
import net.jami.jams.common.objects.contacts.Contact;
import net.jami.jams.common.serialization.database.DatabaseObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactDao
extends AbstractDao<Contact> {
    private static final Logger log = LoggerFactory.getLogger(ContactDao.class);

    public ContactDao() {
        this.setTableName("contacts");
        this.setTClass(Contact.class);
    }

    public List<Contact> getByOwner(String owner) {
        return this.getObjectsFromResultSet("SELECT * FROM contacts WHERE owner = ?", owner);
    }

    @Override
    public boolean storeObject(Contact object) {
        String query = "INSERT INTO contacts (owner, uri, displayName, added, removed, banned, confirmed, conversationId) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        return this.executeInsert(query, (DatabaseObject)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeContactList(List<Contact> contactList) {
        if (contactList.isEmpty()) {
            log.error("Unable to store empty contact list.");
            return false;
        }
        SQLConnection connection = DataStore.connectionPool.getConnection();
        if (connection == null) {
            return false;
        }
        try {
            connection.getConnection().setAutoCommit(false);
            String update = "UPDATE contacts SET displayName = ?, added = ?, removed = ?, banned = ?, confirmed = ?, conversationId = ? WHERE owner = ? AND uri = ?";
            String insert = "INSERT INTO contacts (owner, uri, displayName, added, removed, banned, confirmed, conversationId) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            for (Contact contact : contactList) {
                PreparedStatement updatePs = connection.getConnection().prepareStatement(update);
                contact.getUpdate(updatePs);
                int rowsUpdated = updatePs.executeUpdate();
                if (rowsUpdated != 0) continue;
                PreparedStatement insertPs = connection.getConnection().prepareStatement(insert);
                contact.getInsert(insertPs);
                insertPs.executeUpdate();
                insertPs.close();
            }
            connection.getConnection().commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("An error occurred while attempting to update contacts: {}", (Object)e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            DataStore.connectionPool.returnConnection(connection);
        }
    }

    public boolean removeContact(String owner, String uri) {
        String query = "UPDATE contacts SET removed = ? WHERE owner = ? AND uri = ?";
        String removedTimestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        return this.executeUpdate(query, List.of(removedTimestamp, owner, uri));
    }
}

