/*
 * Decompiled with CFR 0.152.
 */
package com.imperva.ddc.core;

import com.imperva.ddc.core.DDCProperties;
import com.imperva.ddc.core.DriverBase;
import com.imperva.ddc.core.commons.Utils;
import com.imperva.ddc.core.exceptions.AuthenticationException;
import com.imperva.ddc.core.exceptions.BaseException;
import com.imperva.ddc.core.exceptions.EmptyHostException;
import com.imperva.ddc.core.exceptions.InvalidConnectionException;
import com.imperva.ddc.core.exceptions.InvalidIpAddressException;
import com.imperva.ddc.core.exceptions.ProtocolException;
import com.imperva.ddc.core.exceptions.UnknownException;
import com.imperva.ddc.core.exceptions.UnresolvableHostException;
import com.imperva.ddc.core.query.AccountNameType;
import com.imperva.ddc.core.query.DestinationType;
import com.imperva.ddc.core.query.Endpoint;
import com.imperva.ddc.core.query.HoYeah;
import com.imperva.ddc.core.query.LdapConnectionResult;
import com.imperva.ddc.core.query.Oops;
import com.imperva.ddc.core.query.Status;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapProtocolErrorException;
import org.apache.directory.api.ldap.model.message.BindRequestImpl;
import org.apache.directory.api.ldap.model.message.BindResponse;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Driver
extends DriverBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(Driver.class.getName());

    Driver() {
    }

    @Override
    LdapConnectionResult connect(Endpoint endpoint) {
        if (endpoint.getUserAccountName() == null || StringUtils.isEmpty(endpoint.getUserAccountName().trim())) {
            throw new RuntimeException("User Distinguished Name (DN) can't be empty, Anonymous connection is not supported");
        }
        if (StringUtils.isEmpty(endpoint.getPassword())) {
            throw new RuntimeException("Password can't be empty, Anonymous connection is not supported");
        }
        LdapConnectionResult ldapConnectionResult = this.doConnect(endpoint);
        LOGGER.debug("Connection succeeded! Host: {}, port: {}", (Object)endpoint.getResolvedHost(), (Object)endpoint.getPort());
        this.logResult(ldapConnectionResult);
        return ldapConnectionResult;
    }

    private LdapConnectionResult doConnect(Endpoint endpoint) {
        if (endpoint.getLdapConnection() != null && endpoint.getLdapConnection().isConnected() && endpoint.getDestinationType() != DestinationType.NONE) {
            LdapConnectionResult ldapConnectionResult = new LdapConnectionResult();
            ldapConnectionResult.setDestinationType(endpoint.getDestinationType());
            ldapConnectionResult.setConnection(endpoint.getLdapConnection());
            ldapConnectionResult.addStatus(endpoint.getDestinationType() == DestinationType.PRIMARY ? endpoint.getHost() : endpoint.getSecondaryHost(), new HoYeah());
            return ldapConnectionResult;
        }
        if (endpoint.getDestinationType() == DestinationType.NONE) {
            LdapConnectionResult ldapConnectionResult = this.createConnection(endpoint, DestinationType.PRIMARY);
            if (!ldapConnectionResult.hasError() || Utils.isEmpty(endpoint.getSecondaryHost())) {
                return ldapConnectionResult;
            }
            if (endpoint.getLdapConnection() != null) {
                endpoint.close();
            }
            LdapConnectionResult ldapConnectionResultMerged = this.createConnection(endpoint, DestinationType.SECONDARY);
            ldapConnectionResultMerged.addStatus(ldapConnectionResult.getStatuses());
            return ldapConnectionResultMerged;
        }
        return null;
    }

    private LdapConnectionResult createConnection(Endpoint endpoint, DestinationType destinationType) {
        LdapConnectionResult ldapConnectionResult = new LdapConnectionResult();
        String host = destinationType == DestinationType.PRIMARY ? endpoint.getHost() : endpoint.getSecondaryHost();
        int port = destinationType == DestinationType.PRIMARY ? endpoint.getPort() : endpoint.getSecondaryPort();
        try {
            LdapConnection ldapConnection = this.getLdapConnection(endpoint, destinationType);
            if (ldapConnection != null && ldapConnection.isConnected()) {
                ldapConnectionResult = new LdapConnectionResult();
                ldapConnectionResult.setDestinationType(destinationType);
                ldapConnectionResult.setConnection(ldapConnection);
                ldapConnectionResult.addStatus(host, new HoYeah());
            }
        }
        catch (BaseException e) {
            LOGGER.debug("Connection failed! Host: {}, port: {}", (Object)host, (Object)port);
            ldapConnectionResult.addStatus(host, new Oops(e));
        }
        catch (Exception e) {
            LOGGER.debug("Connection failed! Host: {}, port: {}", (Object)host, (Object)port);
            throw e;
        }
        return ldapConnectionResult;
    }

    private void logResult(LdapConnectionResult ldapConnectionResult) {
        if (ldapConnectionResult == null) {
            return;
        }
        ArrayList<String> messages = new ArrayList<String>();
        for (Map.Entry<String, Status> entry : ldapConnectionResult.getStatuses().entrySet()) {
            if (entry.getValue() == null) {
                messages.add("Connection to host " + entry.getKey() + " status unknown");
                continue;
            }
            if (entry.getValue().isError()) {
                messages.add("Connection to host " + entry.getKey() + " has failed. Reason: " + entry.getValue().getMessage());
                continue;
            }
            messages.add("Connection to host " + entry.getKey() + " has succeeded");
        }
        String result = StringUtils.join(messages, ", ");
        if (ldapConnectionResult.getConnection() == null) {
            LOGGER.error("Test connection has failed. Results: {}", (Object)result);
        } else if (ldapConnectionResult.hasError()) {
            LOGGER.info("Test connection has succeeded. Results: {}", (Object)result);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LdapConnection getLdapConnection(Endpoint endpoint, DestinationType destinationType) {
        LdapNetworkConnection connection = null;
        String host = destinationType == DestinationType.PRIMARY ? endpoint.getResolvedHost() : endpoint.getSecondaryResolvedHost();
        int port = destinationType == DestinationType.PRIMARY ? endpoint.getPort() : endpoint.getSecondaryPort();
        Boolean isSecuredConnection = destinationType == DestinationType.PRIMARY ? endpoint.isSecuredConnection() : endpoint.getSecuredConnectionSecondary();
        Boolean isIgnoreSSLValidations = endpoint.isIgnoreSSLValidations();
        String password = endpoint.getPassword();
        AccountNameType accountNameType = endpoint.getOsAccountNameMode();
        String userAccountName = endpoint.getUserAccountName();
        try {
            connection = this.ldapNetworkConnectionGetInstance(host, port, isSecuredConnection, isIgnoreSSLValidations);
            Integer timeout = Integer.parseInt(DDCProperties.getInstance().getProperty("connection.timeout"));
            if (connection instanceof LdapNetworkConnection) {
                connection.getConfig().setTimeout(timeout.intValue());
            }
            BindRequestImpl bindRequest = new BindRequestImpl();
            bindRequest.setCredentials(password);
            bindRequest.setSimple(true);
            if (accountNameType == AccountNameType.DOMAIN_USERNAME) {
                bindRequest.setName(userAccountName);
            } else if (accountNameType == AccountNameType.DN) {
                bindRequest.setDn(new Dn(userAccountName));
            }
            BindResponse bindResponse = connection.bind(bindRequest);
            if (bindResponse.getLdapResult().getResultCode() != ResultCodeEnum.SUCCESS) {
                if (bindResponse.getLdapResult().getResultCode() == ResultCodeEnum.PROTOCOL_ERROR) {
                    throw new LdapProtocolErrorException(this.createLdapErrorMessage(bindResponse));
                }
                if (bindResponse.getLdapResult().getResultCode() != ResultCodeEnum.INVALID_CREDENTIALS) throw new LdapException(this.createLdapErrorMessage(bindResponse));
                throw new LdapAuthenticationException(this.createLdapErrorMessage(bindResponse));
            }
            try {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(connection.getRootDse().toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            LOGGER.debug("Ldap Connection to " + host + " succeeded.");
        }
        catch (LdapAuthenticationException e) {
            try {
                String error = "Ldap Connection to " + host + " failed: " + e.toString();
                LOGGER.error(error, e);
                throw new AuthenticationException(e);
                catch (LdapProtocolErrorException e2) {
                    error = "Ldap Connection to " + host + " failed: " + e2.toString();
                    LOGGER.error(error, e2);
                    throw new ProtocolException(e2);
                }
                catch (org.apache.directory.ldap.client.api.exception.InvalidConnectionException e3) {
                    error = "Ldap Connection to " + host + " failed";
                    LOGGER.error(error, e3);
                    throw new InvalidConnectionException(e3);
                }
                catch (UnresolvableHostException e4) {
                    LOGGER.debug("An UnresolvableHostException has occurred!");
                    error = "Ldap Connection to " + host + " failed";
                    LOGGER.error(error, e4);
                    throw new UnresolvableHostException(e4);
                }
                catch (InvalidIpAddressException e5) {
                    LOGGER.debug("An InvalidIpAddressException has occurred!");
                    error = "Ldap Connection to " + host + " failed";
                    LOGGER.error(error, e5);
                    throw new InvalidIpAddressException(e5);
                }
                catch (EmptyHostException e6) {
                    LOGGER.debug("An EmptyHostException has occurred!");
                    error = "Ldap Connection to " + host + " failed";
                    LOGGER.error(error, e6);
                    throw new EmptyHostException(e6);
                }
                catch (Exception e7) {
                    error = "Ldap Connection to " + host + " failed";
                    LOGGER.error(error, e7);
                    String reason = "An unknown exception occurred. Please make sure your credentials and the IP address / Port are correct and the target Active Directory Server is reachable";
                    throw new UnknownException(e7.getMessage(), reason, e7);
                }
            }
            catch (Throwable throwable) {
                endpoint.setLdapConnection(connection);
                throw throwable;
            }
        }
        endpoint.setLdapConnection(connection);
        return connection;
    }

    private String createLdapErrorMessage(BindResponse bindResponse) {
        return "Error Code: " + (Object)((Object)bindResponse.getLdapResult().getResultCode()) + ". Exception: " + bindResponse.getLdapResult().getDiagnosticMessage();
    }

    LdapNetworkConnection ldapNetworkConnectionGetInstance(String host, Integer port, Boolean isSecuredConnection, Boolean isIgnoreSSLValidations) {
        LdapConnectionConfig ldapConnectionConfig = new LdapConnectionConfig();
        ldapConnectionConfig.setUseSsl(isSecuredConnection);
        ldapConnectionConfig.setLdapHost(host);
        ldapConnectionConfig.setLdapPort(port);
        Boolean ignoreChainException = isIgnoreSSLValidations == null ? Boolean.parseBoolean(DDCProperties.getInstance().getProperty("ignore.ssl.cert.chain.exception")) : isIgnoreSSLValidations;
        if (isSecuredConnection.booleanValue() && ignoreChainException.booleanValue()) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            ldapConnectionConfig.setTrustManagers(trustAllCerts);
        }
        return new LdapNetworkConnection(ldapConnectionConfig);
    }
}

