/*
 * Decompiled with CFR 0.152.
 */
package net.jami.datastore.main;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.jami.datastore.dao.ContactDao;
import net.jami.datastore.dao.DeviceDao;
import net.jami.datastore.dao.GroupDao;
import net.jami.datastore.dao.JwtDao;
import net.jami.datastore.dao.PolicyDao;
import net.jami.datastore.dao.SystemDao;
import net.jami.datastore.dao.UserDao;
import net.jami.datastore.dao.UserGroupMappingsDao;
import net.jami.datastore.dao.UserProfileDao;
import net.jami.jams.common.authentication.AuthenticationSource;
import net.jami.jams.common.authentication.AuthenticationSourceInfo;
import net.jami.jams.common.authentication.AuthenticationSourceType;
import net.jami.jams.common.dao.StatementElement;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.dao.connectivity.ConnectionPool;
import net.jami.jams.common.objects.user.User;
import net.jami.jams.common.objects.user.UserProfile;
import org.flywaydb.core.Flyway;

public class DataStore
implements AuthenticationSource {
    public static ConnectionPool connectionPool;
    private UserDao userDao;
    private GroupDao groupDao;
    private PolicyDao policyDao;
    private DeviceDao deviceDao;
    private SystemDao systemDao;
    private ContactDao contactDao;
    private JwtDao jwtDao;
    private UserProfileDao userProfileDao;
    private UserGroupMappingsDao userGroupMappingsDao;
    public static final Integer RESULTS_PER_PAGE;
    public static Integer NUM_PAGES;

    public DataStore(String connectionString) {
        Flyway flyway = Flyway.configure().dataSource(connectionString, "", "").load();
        flyway.migrate();
        connectionPool = new ConnectionPool(connectionString);
        this.userDao = new UserDao();
        this.groupDao = new GroupDao();
        this.policyDao = new PolicyDao();
        this.deviceDao = new DeviceDao();
        this.systemDao = new SystemDao();
        this.contactDao = new ContactDao();
        this.jwtDao = new JwtDao();
        this.userProfileDao = new UserProfileDao();
        this.userGroupMappingsDao = new UserGroupMappingsDao();
    }

    public boolean userExists(String username) {
        StatementList statementList = new StatementList();
        StatementElement statementElement = new StatementElement("username", "=", username, "");
        statementList.addStatement(statementElement);
        List userList = this.userDao.getObjects(statementList);
        return userList.size() == 1;
    }

    public boolean createUser(User user) {
        return this.userDao.storeObject(user);
    }

    public List<UserProfile> searchUserProfiles(String queryString, String field, Optional<Integer> page) {
        List<UserProfile> userList;
        if (!queryString.equals("*")) {
            StatementList statementList = new StatementList();
            String startQueryString = queryString.concat("%");
            if (field.equals("LOGON_NAME")) {
                statementList.addStatement(new StatementElement("username", "LIKE", startQueryString, ""));
            } else if (field.equals("FULL_TEXT_NAME")) {
                statementList.addStatement(new StatementElement("firstName", "LIKE", startQueryString, "OR"));
                statementList.addStatement(new StatementElement("lastName", "LIKE", startQueryString, ""));
            }
            userList = this.userProfileDao.getObjects(statementList);
        } else {
            userList = this.userProfileDao.getObjects(null);
        }
        if (userList == null) {
            userList = new ArrayList();
        }
        NUM_PAGES = Integer.valueOf(userList.size()) / RESULTS_PER_PAGE;
        if (userList.size() % RESULTS_PER_PAGE != 0) {
            Integer n = NUM_PAGES;
            NUM_PAGES = NUM_PAGES + 1;
        }
        if (page.isPresent() && !userList.isEmpty()) {
            userList = userList.size() < RESULTS_PER_PAGE ? userList.subList(0, userList.size()) : (page.get() * RESULTS_PER_PAGE > userList.size() ? userList.subList((page.get() - 1) * RESULTS_PER_PAGE, userList.size()) : userList.subList((page.get() - 1) * RESULTS_PER_PAGE, page.get() * RESULTS_PER_PAGE));
        }
        return userList;
    }

    public UserProfile getUserProfile(String username) {
        StatementList statementList = new StatementList();
        statementList.addStatement(new StatementElement("username", "=", username, ""));
        List userList = this.userProfileDao.getObjects(statementList);
        if (userList.size() != 1) {
            return null;
        }
        return (UserProfile)userList.get(0);
    }

    public boolean setUserProfile(UserProfile userProfile) {
        return this.userProfileDao.storeObject(userProfile);
    }

    public boolean updateUserProfile(UserProfile userProfile) {
        StatementList update = new StatementList();
        update.addStatement(new StatementElement("username", "=", userProfile.getUsername(), ""));
        update.addStatement(new StatementElement("firstName", "=", userProfile.getFirstName(), ""));
        update.addStatement(new StatementElement("lastName", "=", userProfile.getLastName(), ""));
        update.addStatement(new StatementElement("email", "=", userProfile.getEmail(), ""));
        update.addStatement(new StatementElement("profilePicture", "=", userProfile.getProfilePicture(), ""));
        update.addStatement(new StatementElement("organization", "=", userProfile.getOrganization(), ""));
        update.addStatement(new StatementElement("phoneNumber", "=", userProfile.getPhoneNumber(), ""));
        update.addStatement(new StatementElement("phoneNumberExtension", "=", userProfile.getPhoneNumberExtension(), ""));
        update.addStatement(new StatementElement("faxNumber", "=", userProfile.getFaxNumber(), ""));
        update.addStatement(new StatementElement("mobileNumber", "=", userProfile.getMobileNumber(), ""));
        return this.userProfileDao.updateObject(update, null);
    }

    public boolean authenticate(String username, String password) {
        StatementList statementList = new StatementList();
        StatementElement statementElement = new StatementElement("username", "=", username, "");
        statementList.addStatement(statementElement);
        List userList = this.userDao.getObjects(statementList);
        if (userList.size() != 1 || ((User)userList.get(0)).getPassword() == null) {
            return false;
        }
        return ((User)userList.get(0)).getPassword().equals(password);
    }

    public AuthenticationSourceInfo getInfo() {
        return new AuthenticationSourceInfo("LOCAL", AuthenticationSourceType.LOCAL);
    }

    public boolean test() {
        return true;
    }

    public boolean updatePassword(User user, String password) {
        return false;
    }

    public UserDao getUserDao() {
        return this.userDao;
    }

    public GroupDao getGroupDao() {
        return this.groupDao;
    }

    public PolicyDao getPolicyDao() {
        return this.policyDao;
    }

    public DeviceDao getDeviceDao() {
        return this.deviceDao;
    }

    public SystemDao getSystemDao() {
        return this.systemDao;
    }

    public ContactDao getContactDao() {
        return this.contactDao;
    }

    public JwtDao getJwtDao() {
        return this.jwtDao;
    }

    public UserProfileDao getUserProfileDao() {
        return this.userProfileDao;
    }

    public UserGroupMappingsDao getUserGroupMappingsDao() {
        return this.userGroupMappingsDao;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    public void setGroupDao(GroupDao groupDao) {
        this.groupDao = groupDao;
    }

    public void setPolicyDao(PolicyDao policyDao) {
        this.policyDao = policyDao;
    }

    public void setDeviceDao(DeviceDao deviceDao) {
        this.deviceDao = deviceDao;
    }

    public void setSystemDao(SystemDao systemDao) {
        this.systemDao = systemDao;
    }

    public void setContactDao(ContactDao contactDao) {
        this.contactDao = contactDao;
    }

    public void setJwtDao(JwtDao jwtDao) {
        this.jwtDao = jwtDao;
    }

    public void setUserProfileDao(UserProfileDao userProfileDao) {
        this.userProfileDao = userProfileDao;
    }

    public void setUserGroupMappingsDao(UserGroupMappingsDao userGroupMappingsDao) {
        this.userGroupMappingsDao = userGroupMappingsDao;
    }

    static {
        RESULTS_PER_PAGE = 24;
    }
}

