/*
 * Decompiled with CFR 0.152.
 */
package net.jami.datastore.dao;

import java.sql.PreparedStatement;
import net.jami.datastore.dao.AbstractDao;
import net.jami.datastore.main.DataStore;
import net.jami.jams.common.dao.StatementElement;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.dao.connectivity.SQLConnection;
import net.jami.jams.common.objects.user.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDao
extends AbstractDao<User> {
    private static final Logger log = LoggerFactory.getLogger(UserDao.class);

    public UserDao() {
        this.setTableName("users");
        this.setTClass(User.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storeObject(User object) {
        SQLConnection connection = DataStore.connectionPool.getConnection();
        try {
            PreparedStatement ps = connection.getConnection().prepareStatement("INSERT INTO users (username, password, userType, realm, ethAddress, ethKey, jamiId,certificate, privatekey, accessLevel, needsPasswordReset, salt)  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            ps = object.getInsert(ps);
            boolean bl = ps.executeUpdate() != 0;
            return bl;
        }
        catch (Exception e) {
            log.error("An error has occurred while trying to store a user: " + e.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            DataStore.connectionPool.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateObject(StatementList update, StatementList constraints) {
        String pw = ((StatementElement)update.getStatements().get(0)).getValue();
        String salt = "";
        if (update.getStatements().size() > 1) {
            salt = ((StatementElement)update.getStatements().get(1)).getValue();
        }
        String user = ((StatementElement)constraints.getStatements().get(0)).getValue();
        SQLConnection connection = DataStore.connectionPool.getConnection();
        try {
            PreparedStatement ps = connection.getConnection().prepareStatement("UPDATE users SET password = ?, salt = ? WHERE username = ?");
            ps.setString(1, pw);
            ps.setString(2, salt);
            ps.setString(3, user);
            boolean bl = ps.executeUpdate() != 0;
            return bl;
        }
        catch (Exception e) {
            log.error("An error has occurred while trying to update a user: " + e.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            DataStore.connectionPool.returnConnection(connection);
        }
    }
}

