/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.extra;

import com.jsoniter.CodegenAccess;
import com.jsoniter.JsonIterator;
import com.jsoniter.any.Any;
import com.jsoniter.extra.Base64;
import com.jsoniter.output.JsonStream;
import com.jsoniter.spi.Decoder;
import com.jsoniter.spi.Encoder;
import com.jsoniter.spi.JsonException;
import com.jsoniter.spi.JsoniterSpi;
import com.jsoniter.spi.Slice;
import java.io.IOException;

public class Base64FloatSupport {
    static final int[] DIGITS = new int[256];
    static final int[] HEX = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    static final int[] DEC = new int[127];
    private static boolean enabled;

    public static synchronized void enableEncodersAndDecoders() {
        if (enabled) {
            throw new JsonException("BinaryFloatSupport.enable can only be called once");
        }
        enabled = true;
        Base64FloatSupport.enableDecoders();
        JsoniterSpi.registerTypeEncoder(Double.class, (Encoder)new Encoder.ReflectionEncoder(){

            @Override
            public void encode(Object obj, JsonStream stream) throws IOException {
                Double number = (Double)obj;
                long bits = Double.doubleToRawLongBits(number);
                Base64.encodeLongBits(bits, stream);
            }

            @Override
            public Any wrap(Object obj) {
                Double number = (Double)obj;
                return Any.wrap(number);
            }
        });
        JsoniterSpi.registerTypeEncoder(Double.TYPE, (Encoder)new Encoder.DoubleEncoder(){

            @Override
            public void encodeDouble(double obj, JsonStream stream) throws IOException {
                long bits = Double.doubleToRawLongBits(obj);
                Base64.encodeLongBits(bits, stream);
            }
        });
        JsoniterSpi.registerTypeEncoder(Float.class, (Encoder)new Encoder.ReflectionEncoder(){

            @Override
            public void encode(Object obj, JsonStream stream) throws IOException {
                Float number = (Float)obj;
                long bits = Double.doubleToRawLongBits(number.doubleValue());
                Base64.encodeLongBits(bits, stream);
            }

            @Override
            public Any wrap(Object obj) {
                Float number = (Float)obj;
                return Any.wrap(number.floatValue());
            }
        });
        JsoniterSpi.registerTypeEncoder(Float.TYPE, (Encoder)new Encoder.FloatEncoder(){

            @Override
            public void encodeFloat(float obj, JsonStream stream) throws IOException {
                long bits = Double.doubleToRawLongBits(obj);
                Base64.encodeLongBits(bits, stream);
            }
        });
    }

    public static void enableDecoders() {
        JsoniterSpi.registerTypeDecoder(Double.class, new Decoder(){

            @Override
            public Object decode(JsonIterator iter) throws IOException {
                byte token = CodegenAccess.nextToken(iter);
                CodegenAccess.unreadByte(iter);
                if (token == 34) {
                    return Double.longBitsToDouble(Base64.decodeLongBits(iter));
                }
                return iter.readDouble();
            }
        });
        JsoniterSpi.registerTypeDecoder(Double.TYPE, (Decoder)new Decoder.DoubleDecoder(){

            @Override
            public double decodeDouble(JsonIterator iter) throws IOException {
                byte token = CodegenAccess.nextToken(iter);
                CodegenAccess.unreadByte(iter);
                if (token == 34) {
                    return Double.longBitsToDouble(Base64.decodeLongBits(iter));
                }
                return iter.readDouble();
            }
        });
        JsoniterSpi.registerTypeDecoder(Float.class, new Decoder(){

            @Override
            public Object decode(JsonIterator iter) throws IOException {
                byte token = CodegenAccess.nextToken(iter);
                CodegenAccess.unreadByte(iter);
                if (token == 34) {
                    return Float.valueOf((float)Double.longBitsToDouble(Base64.decodeLongBits(iter)));
                }
                return Float.valueOf((float)iter.readDouble());
            }
        });
        JsoniterSpi.registerTypeDecoder(Float.TYPE, (Decoder)new Decoder.FloatDecoder(){

            @Override
            public float decodeFloat(JsonIterator iter) throws IOException {
                byte token = CodegenAccess.nextToken(iter);
                CodegenAccess.unreadByte(iter);
                if (token == 34) {
                    return (float)Double.longBitsToDouble(Base64.decodeLongBits(iter));
                }
                return (float)iter.readDouble();
            }
        });
    }

    private static long readLongBits(JsonIterator iter) throws IOException {
        Slice slice = iter.readStringAsSlice();
        byte[] data = slice.data();
        long val2 = 0L;
        for (int i = slice.head(); i < slice.tail(); ++i) {
            byte b = data[i];
            val2 = val2 << 4 | (long)DEC[b];
        }
        return val2;
    }

    private static void writeLongBits(long bits, JsonStream stream) throws IOException {
        int digit = DIGITS[(int)(bits & 0xFFL)];
        byte b2 = (byte)(digit >> 8);
        byte b1 = (byte)digit;
        if ((bits >>= 8) == 0L) {
            stream.write((byte)34, b2, b1, (byte)34);
        }
        digit = DIGITS[(int)(bits & 0xFFL)];
        byte b4 = (byte)(digit >> 8);
        byte b3 = (byte)digit;
        if ((bits >>= 8) == 0L) {
            stream.write((byte)34, b4, b3, b2, b1, (byte)34);
        }
        digit = DIGITS[(int)(bits & 0xFFL)];
        byte b6 = (byte)(digit >> 8);
        byte b5 = (byte)digit;
        if ((bits >>= 8) == 0L) {
            stream.write((byte)34, b6, b5, b4, b3);
            stream.write(b2, b1, (byte)34);
        }
        digit = DIGITS[(int)(bits & 0xFFL)];
        byte b8 = (byte)(digit >> 8);
        byte b7 = (byte)digit;
        if ((bits >>= 8) == 0L) {
            stream.write((byte)34, b8, b7, b6, b5, b4);
            stream.write(b3, b2, b1, (byte)34);
        }
        digit = DIGITS[(int)(bits & 0xFFL)];
        byte b10 = (byte)(digit >> 8);
        byte b9 = (byte)digit;
        if ((bits >>= 8) == 0L) {
            stream.write((byte)34, b10, b9, b8, b7, b6);
            stream.write(b5, b4, b3, b2, b1, (byte)34);
        }
        digit = DIGITS[(int)(bits & 0xFFL)];
        byte b12 = (byte)(digit >> 8);
        byte b11 = (byte)digit;
        if ((bits >>= 8) == 0L) {
            stream.write((byte)34, b12, b11, b10, b9, b8);
            stream.write(b7, b6, b5, b4, b3, b2);
            stream.write(b1, (byte)34);
        }
        digit = DIGITS[(int)(bits & 0xFFL)];
        byte b14 = (byte)(digit >> 8);
        byte b13 = (byte)digit;
        if ((bits >>= 8) == 0L) {
            stream.write((byte)34, b14, b13, b12, b11, b10);
            stream.write(b9, b8, b7, b6, b5, b4);
            stream.write(b3, b2, b1, (byte)34);
        }
        digit = DIGITS[(int)(bits & 0xFFL)];
        byte b16 = (byte)(digit >> 8);
        byte b15 = (byte)digit;
        stream.write((byte)34, b16, b15, b14, b13, b12);
        stream.write(b11, b10, b9, b8, b7, b6);
        stream.write(b5, b4, b3, b2, b1, (byte)34);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            Base64FloatSupport.DIGITS[i] = HEX[i >> 4] << 8 | HEX[i & 0xF];
        }
        Base64FloatSupport.DEC[48] = 0;
        Base64FloatSupport.DEC[49] = 1;
        Base64FloatSupport.DEC[50] = 2;
        Base64FloatSupport.DEC[51] = 3;
        Base64FloatSupport.DEC[52] = 4;
        Base64FloatSupport.DEC[53] = 5;
        Base64FloatSupport.DEC[54] = 6;
        Base64FloatSupport.DEC[55] = 7;
        Base64FloatSupport.DEC[56] = 8;
        Base64FloatSupport.DEC[57] = 9;
        Base64FloatSupport.DEC[97] = 10;
        Base64FloatSupport.DEC[98] = 11;
        Base64FloatSupport.DEC[99] = 12;
        Base64FloatSupport.DEC[100] = 13;
        Base64FloatSupport.DEC[101] = 14;
        Base64FloatSupport.DEC[102] = 15;
    }
}

