/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.shaded.freemarker.log;

import java.util.HashMap;
import java.util.Map;
import org.mapstruct.ap.shaded.freemarker.core.BugException;
import org.mapstruct.ap.shaded.freemarker.log.LoggerFactory;
import org.mapstruct.ap.shaded.freemarker.log._NullLoggerFactory;

public abstract class Logger {
    public static final int LIBRARY_AUTO = -1;
    public static final int LIBRARY_NONE = 0;
    public static final int LIBRARY_JAVA = 1;
    public static final int LIBRARY_AVALON = 2;
    public static final int LIBRARY_LOG4J = 3;
    public static final int LIBRARY_COMMONS = 4;
    public static final int LIBRARY_SLF4J = 5;
    private static final String[] LIBINIT = new String[]{"org.mapstruct.ap.shaded.freemarker.log.Logger", "_Null", "java.util.logging.Logger", "_JDK14", "org.apache.log.Logger", "_Avalon", "org.apache.log4j.Logger", "_Log4J", "org.apache.commons.logging.Log", "CommonsLogging", "org.slf4j.Logger", "SLF4J"};
    private static int logLibrary;
    private static LoggerFactory factory;
    private static String categoryPrefix;
    private static final Map loggers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void selectLoggerLibrary(int library) throws ClassNotFoundException {
        Class clazz = Logger.class;
        synchronized (clazz) {
            if (library < -1 || library * 2 >= LIBINIT.length) {
                throw new IllegalArgumentException();
            }
            logLibrary = library;
            factory = Logger.createFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCategoryPrefix(String prefix) {
        Class clazz = Logger.class;
        synchronized (clazz) {
            if (prefix == null) {
                throw new IllegalArgumentException();
            }
            categoryPrefix = prefix;
        }
    }

    public abstract void debug(String var1);

    public abstract void debug(String var1, Throwable var2);

    public abstract void info(String var1);

    public abstract void info(String var1, Throwable var2);

    public abstract void warn(String var1);

    public abstract void warn(String var1, Throwable var2);

    public abstract void error(String var1);

    public abstract void error(String var1, Throwable var2);

    public abstract boolean isDebugEnabled();

    public abstract boolean isInfoEnabled();

    public abstract boolean isWarnEnabled();

    public abstract boolean isErrorEnabled();

    public abstract boolean isFatalEnabled();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String category) {
        Object object;
        if (factory == null) {
            object = Logger.class;
            synchronized (object) {
                if (factory == null) {
                    try {
                        Logger.selectLoggerLibrary(-1);
                    }
                    catch (ClassNotFoundException e) {
                        throw new BugException(e);
                    }
                }
            }
        }
        category = categoryPrefix + category;
        object = loggers;
        synchronized (object) {
            Logger logger = (Logger)loggers.get(category);
            if (logger == null) {
                logger = factory.getLogger(category);
                loggers.put(category, logger);
            }
            return logger;
        }
    }

    private static LoggerFactory createFactory() throws ClassNotFoundException {
        if (logLibrary == -1) {
            for (int i = LIBINIT.length / 2 - 1; i > 0; --i) {
                if (i == 5 || i == 4) continue;
                try {
                    return Logger.createFactory(i);
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
                catch (LinkageError linkageError) {
                    // empty catch block
                }
            }
            System.err.println("*** WARNING: FreeMarker logging suppressed.");
            return new _NullLoggerFactory();
        }
        return Logger.createFactory(logLibrary);
    }

    private static LoggerFactory createFactory(int library) throws ClassNotFoundException {
        String loggerClassName = LIBINIT[library * 2];
        String factoryType = LIBINIT[library * 2 + 1];
        try {
            Class.forName(loggerClassName);
            return (LoggerFactory)Class.forName("org.mapstruct.ap.shaded.freemarker.log." + factoryType + "LoggerFactory").newInstance();
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new InstantiationError(e.getMessage());
        }
    }

    static {
        categoryPrefix = "";
        loggers = new HashMap();
    }
}

