/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.schema;

import java.text.ParseException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ldaptive.LdapUtils;
import org.ldaptive.schema.AbstractNamedSchemaElement;
import org.ldaptive.schema.Extensions;
import org.ldaptive.schema.SchemaUtils;

public class MatchingRuleUse
extends AbstractNamedSchemaElement {
    private static final int HASH_CODE_SEED = 1123;
    private static final Pattern DEFINITION_PATTERN = Pattern.compile("[ ]*\\([ ]*([^ ]+)[ ]*(?:NAME (?:'([^']+)'|\\(([^\\)]+)\\)))?[ ]*(?:DESC '([^']*)')?[ ]*(OBSOLETE)?[ ]*(?:APPLIES (?:([^ ]+)|\\(([^\\)]+)\\)))?[ ]*(?:(X-[^ ]+.*))?[ ]*\\)[ ]*");
    private final String oid;
    private String[] appliesAttributeTypes;

    public MatchingRuleUse(String s) {
        this.oid = s;
    }

    public MatchingRuleUse(String oid, String[] names, String description, boolean obsolete, String[] appliesAttributeTypes, Extensions extensions) {
        this(oid);
        this.setNames(names);
        this.setDescription(description);
        this.setObsolete(obsolete);
        this.setAppliesAttributeTypes(appliesAttributeTypes);
        this.setExtensions(extensions);
    }

    public String getOID() {
        return this.oid;
    }

    public String[] getAppliesAttributeTypes() {
        return this.appliesAttributeTypes;
    }

    public void setAppliesAttributeTypes(String[] s) {
        this.appliesAttributeTypes = s;
    }

    public static MatchingRuleUse parse(String definition) throws ParseException {
        Matcher m = DEFINITION_PATTERN.matcher(definition);
        if (!m.matches()) {
            throw new ParseException("Invalid matching rule use definition: " + definition, definition.length());
        }
        MatchingRuleUse mrud = new MatchingRuleUse(m.group(1).trim());
        if (m.group(2) != null) {
            mrud.setNames(SchemaUtils.parseDescriptors(m.group(2).trim()));
        } else if (m.group(3) != null) {
            mrud.setNames(SchemaUtils.parseDescriptors(m.group(3).trim()));
        }
        mrud.setDescription(m.group(4) != null ? m.group(4).trim() : null);
        mrud.setObsolete(m.group(5) != null);
        if (m.group(6) != null) {
            mrud.setAppliesAttributeTypes(SchemaUtils.parseOIDs(m.group(6).trim()));
        } else if (m.group(7) != null) {
            mrud.setAppliesAttributeTypes(SchemaUtils.parseOIDs(m.group(7).trim()));
        }
        if (m.group(8) != null) {
            mrud.setExtensions(Extensions.parse(m.group(8).trim()));
        }
        return mrud;
    }

    @Override
    public String format() {
        StringBuilder sb = new StringBuilder("( ");
        sb.append(this.oid).append(" ");
        if (this.getNames() != null && this.getNames().length > 0) {
            sb.append("NAME ");
            sb.append(SchemaUtils.formatDescriptors(this.getNames()));
        }
        if (this.getDescription() != null) {
            sb.append("DESC ");
            sb.append(SchemaUtils.formatDescriptors(this.getDescription()));
        }
        if (this.isObsolete()) {
            sb.append("OBSOLETE ");
        }
        if (this.appliesAttributeTypes != null && this.appliesAttributeTypes.length > 0) {
            sb.append("APPLIES ");
            sb.append(SchemaUtils.formatOids(this.appliesAttributeTypes));
        }
        if (this.getExtensions() != null) {
            sb.append(this.getExtensions().format());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MatchingRuleUse) {
            MatchingRuleUse v = (MatchingRuleUse)o;
            return LdapUtils.areEqual(this.oid, v.oid) && LdapUtils.areEqual(this.getNames(), v.getNames()) && LdapUtils.areEqual(this.getDescription(), v.getDescription()) && LdapUtils.areEqual(this.isObsolete(), v.isObsolete()) && LdapUtils.areEqual(this.appliesAttributeTypes, v.appliesAttributeTypes) && LdapUtils.areEqual(this.getExtensions(), v.getExtensions());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(1123, this.oid, this.getNames(), this.getDescription(), this.isObsolete(), this.appliesAttributeTypes, this.getExtensions());
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::" + "oid=" + this.oid + ", " + "names=" + Arrays.toString(this.getNames()) + ", " + "description=" + this.getDescription() + ", " + "obsolete=" + this.isObsolete() + ", " + "appliesAttributeTypes=" + Arrays.toString(this.appliesAttributeTypes) + ", " + "extensions=" + this.getExtensions() + "]";
    }
}

