/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.schema;

import java.text.ParseException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ldaptive.LdapUtils;
import org.ldaptive.schema.AbstractNamedSchemaElement;
import org.ldaptive.schema.Extensions;
import org.ldaptive.schema.SchemaUtils;

public class MatchingRule
extends AbstractNamedSchemaElement {
    private static final int HASH_CODE_SEED = 1117;
    private static final Pattern DEFINITION_PATTERN = Pattern.compile("[ ]*\\([ ]*([^ ]+)[ ]*(?:NAME (?:'([^']+)'|\\(([^\\)]+)\\)))?[ ]*(?:DESC '([^']*)')?[ ]*(OBSOLETE)?[ ]*(?:SYNTAX ([^ ]+))?[ ]*(?:(X-[^ ]+.*))?[ ]*\\)[ ]*");
    private final String oid;
    private String syntaxOID;

    public MatchingRule(String s) {
        this.oid = s;
    }

    public MatchingRule(String oid, String[] names, String description, boolean obsolete, String syntaxOID, Extensions extensions) {
        this(oid);
        this.setNames(names);
        this.setDescription(description);
        this.setObsolete(obsolete);
        this.setSyntaxOID(syntaxOID);
        this.setExtensions(extensions);
    }

    public String getOID() {
        return this.oid;
    }

    public String getSyntaxOID() {
        return this.syntaxOID;
    }

    public void setSyntaxOID(String s) {
        this.syntaxOID = s;
    }

    public static MatchingRule parse(String definition) throws ParseException {
        Matcher m = DEFINITION_PATTERN.matcher(definition);
        if (!m.matches()) {
            throw new ParseException("Invalid matching rule definition: " + definition, definition.length());
        }
        MatchingRule mrd = new MatchingRule(m.group(1).trim());
        if (m.group(2) != null) {
            mrd.setNames(SchemaUtils.parseDescriptors(m.group(2).trim()));
        } else if (m.group(3) != null) {
            mrd.setNames(SchemaUtils.parseDescriptors(m.group(3).trim()));
        }
        mrd.setDescription(m.group(4) != null ? m.group(4).trim() : null);
        mrd.setObsolete(m.group(5) != null);
        mrd.setSyntaxOID(m.group(6) != null ? m.group(6).trim() : null);
        if (m.group(7) != null) {
            mrd.setExtensions(Extensions.parse(m.group(7).trim()));
        }
        return mrd;
    }

    @Override
    public String format() {
        StringBuilder sb = new StringBuilder("( ");
        sb.append(this.oid).append(" ");
        if (this.getNames() != null && this.getNames().length > 0) {
            sb.append("NAME ");
            sb.append(SchemaUtils.formatDescriptors(this.getNames()));
        }
        if (this.getDescription() != null) {
            sb.append("DESC ");
            sb.append(SchemaUtils.formatDescriptors(this.getDescription()));
        }
        if (this.isObsolete()) {
            sb.append("OBSOLETE ");
        }
        if (this.syntaxOID != null) {
            sb.append("SYNTAX ").append(this.syntaxOID).append(" ");
        }
        if (this.getExtensions() != null) {
            sb.append(this.getExtensions().format());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MatchingRule) {
            MatchingRule v = (MatchingRule)o;
            return LdapUtils.areEqual(this.oid, v.oid) && LdapUtils.areEqual(this.getNames(), v.getNames()) && LdapUtils.areEqual(this.getDescription(), v.getDescription()) && LdapUtils.areEqual(this.isObsolete(), v.isObsolete()) && LdapUtils.areEqual(this.syntaxOID, v.syntaxOID) && LdapUtils.areEqual(this.getExtensions(), v.getExtensions());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(1117, this.oid, this.getNames(), this.getDescription(), this.isObsolete(), this.syntaxOID, this.getExtensions());
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::" + "oid=" + this.oid + ", " + "names=" + Arrays.toString(this.getNames()) + ", " + "description=" + this.getDescription() + ", " + "obsolete=" + this.isObsolete() + ", " + "syntaxOID=" + this.syntaxOID + ", " + "extensions=" + this.getExtensions() + "]";
    }
}

