/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.ldaptive.AbstractConnectionStrategy;
import org.ldaptive.LdapURL;
import org.ldaptive.LdapURLRetryMetadata;
import org.ldaptive.LdapURLSet;
import org.ldaptive.dns.DNSContextFactory;
import org.ldaptive.dns.DefaultDNSContextFactory;
import org.ldaptive.dns.SRVDNSResolver;
import org.ldaptive.dns.SRVRecord;

public class DnsSrvConnectionStrategy
extends AbstractConnectionStrategy {
    protected static final Duration DEFAULT_TTL = Duration.ofHours(6L);
    private final DNSContextFactory dnsContextFactory;
    private final Duration srvTtl;
    private final boolean useSSL;
    private String ldapUrls;
    private Map<SRVDNSResolver, String> dnsResolvers;
    private Instant expirationTime;

    public DnsSrvConnectionStrategy() {
        this(DEFAULT_TTL);
    }

    public DnsSrvConnectionStrategy(Duration ttl) {
        this(null, ttl);
    }

    public DnsSrvConnectionStrategy(DNSContextFactory factory) {
        this(factory, DEFAULT_TTL);
    }

    public DnsSrvConnectionStrategy(DNSContextFactory factory, Duration ttl) {
        this(factory, ttl, false);
    }

    public DnsSrvConnectionStrategy(DNSContextFactory factory, Duration ttl, boolean ssl) {
        this.dnsContextFactory = factory;
        this.srvTtl = ttl;
        this.useSSL = ssl;
    }

    @Override
    public void populate(String urls, LdapURLSet urlSet) {
        this.ldapUrls = urls;
        List<LdapURL> list = this.readSrvRecords(this.ldapUrls).stream().map(srv -> {
            LdapURL url = srv.getLdapURL();
            url.setRetryMetadata(new LdapURLRetryMetadata(this));
            return url;
        }).collect(Collectors.toList());
        urlSet.populate(list);
    }

    protected Set<SRVRecord> readSrvRecords(String urls) {
        if (urls == null) {
            this.dnsResolvers = this.dnsContextFactory == null ? Collections.singletonMap(new SRVDNSResolver(new DefaultDNSContextFactory(new String[0]), this.useSSL), null) : Collections.singletonMap(new SRVDNSResolver(this.dnsContextFactory, this.useSSL), null);
        } else if (urls.contains(" ")) {
            this.dnsResolvers = new HashMap<SRVDNSResolver, String>();
            for (String url : urls.split(" ")) {
                String[] dnsUrl = this.parseDnsUrl(url);
                this.dnsResolvers.put(new SRVDNSResolver(Objects.requireNonNullElseGet(this.dnsContextFactory, () -> new DefaultDNSContextFactory(dnsUrl[0])), this.useSSL), dnsUrl[1]);
            }
        } else {
            String[] dnsUrl = this.parseDnsUrl(urls);
            this.dnsResolvers = this.dnsContextFactory == null ? Collections.singletonMap(new SRVDNSResolver(new DefaultDNSContextFactory(dnsUrl[0]), this.useSSL), dnsUrl[1]) : Collections.singletonMap(new SRVDNSResolver(this.dnsContextFactory, this.useSSL), dnsUrl[1]);
        }
        Set<SRVRecord> srvRecords = this.retrieveDNSRecords();
        if (srvRecords.isEmpty()) {
            this.logger.error("No SRV records found using {}", (Object)this.dnsResolvers);
            this.expirationTime = Instant.now();
        } else {
            this.expirationTime = Instant.now().plus(this.srvTtl);
        }
        return srvRecords;
    }

    protected String[] parseDnsUrl(String url) {
        if (!url.contains("?")) {
            return new String[]{url, null};
        }
        return url.split("\\?");
    }

    @Override
    public synchronized Iterator<LdapURL> iterator() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Strategy is not initialized");
        }
        if (Instant.now().isAfter(this.expirationTime)) {
            this.populate(this.ldapUrls, this.ldapURLSet);
        }
        return new AbstractConnectionStrategy.DefaultLdapURLIterator(this.ldapURLSet.getUrls());
    }

    protected Set<SRVRecord> retrieveDNSRecords() {
        for (Map.Entry<SRVDNSResolver, String> entry : this.dnsResolvers.entrySet()) {
            try {
                Set<SRVRecord> records = entry.getKey().resolve(entry.getValue());
                if (records == null || records.isEmpty()) continue;
                return records;
            }
            catch (Exception e) {
                this.logger.error("Could not resolve SRV record {} using {}", entry.getValue(), entry.getKey(), e);
            }
        }
        return Collections.emptySet();
    }
}

