/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.filters;

import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.SignedJWT;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Date;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.server.Server;
import net.jami.jams.server.servlets.api.auth.login.AuthRequestProcessor;
import net.jami.jams.server.servlets.filters.AuthRequestType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterUtils {
    private static final Logger log = LoggerFactory.getLogger(FilterUtils.class);
    public static final String USERNAME_ATTR = "username";
    public static final String ACCESS_LEVEL_ATTR = "accessLevel";

    public static boolean verifyValidity(SignedJWT signedJWT) {
        try {
            return signedJWT.getJWTClaimsSet().getExpirationTime().compareTo(new Date()) > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static AuthRequestType classifyRequest(HttpServletRequest request) {
        if (request.getHeader("authorization") != null) {
            if (request.getHeader("authorization").contains("basic") || request.getHeader("authorization").contains("Basic")) {
                return AuthRequestType.BASIC;
            }
            if (request.getHeader("authorization").contains("bearer") || request.getHeader("authorization").contains("Bearer")) {
                return AuthRequestType.BEARER_TOKEN;
            }
            return null;
        }
        return null;
    }

    public static boolean doAuthCheck(HttpServletRequest request) {
        AuthRequestType requestType = FilterUtils.classifyRequest(request);
        try {
            if (requestType != null) {
                SignedJWT token = null;
                switch (requestType) {
                    case BASIC: {
                        token = SignedJWT.parse(AuthRequestProcessor.processUsernamePasswordAuth(request.getHeader("authorization")).getAccess_token());
                        break;
                    }
                    case BEARER_TOKEN: {
                        token = SignedJWT.parse(request.getHeader("authorization").replace("bearer", "").replace("Bearer", ""));
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                RSASSAVerifier jwsVerifier = new RSASSAVerifier(Server.userAuthenticationModule.getAuthModulePubKey());
                if (token.verify(jwsVerifier) && FilterUtils.verifyValidity(token)) {
                    request.setAttribute(USERNAME_ATTR, token.getJWTClaimsSet().getSubject());
                    request.setAttribute(ACCESS_LEVEL_ATTR, AccessLevel.valueOf((String)token.getJWTClaimsSet().getClaim("scope").toString()));
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            log.info("Failed to process authentication request and denying access: {}", (Object)e.getMessage());
            return false;
        }
    }
}

