/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.admin.group;

import com.jsoniter.output.JsonStream;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.dao.StatementElement;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.objects.user.UserGroupMapping;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/admin/group/members/*"})
public class UserGroupServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(UserGroupServlet.class);

    @Override
    @JsonContent
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String groupId = req.getPathInfo().replace("/", "");
        StatementList statementList = new StatementList();
        StatementElement st = new StatementElement("groupId", "=", groupId, "");
        statementList.addStatement(st);
        List result = Server.dataStore.getUserGroupMappingsDao().getObjects(statementList);
        if (result.isEmpty()) {
            resp.sendError(404, "No users found for this group!");
        } else {
            resp.getOutputStream().write(JsonStream.serialize(result).getBytes());
            resp.setStatus(200);
        }
    }

    @Override
    @JsonContent
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String groupId = req.getPathInfo().replace("/", "");
        JSONObject obj = new JSONObject(req.getReader().lines().collect(Collectors.joining(System.lineSeparator())));
        String username = obj.getString("username");
        StatementList statementList = new StatementList();
        statementList.addStatement(new StatementElement("groupId", "=", groupId, "AND"));
        statementList.addStatement(new StatementElement("username", "=", username, ""));
        if (!Server.dataStore.getUserGroupMappingsDao().getObjects(statementList).isEmpty()) {
            resp.sendError(409, "The user already part of the group!");
            return;
        }
        UserGroupMapping mapping = new UserGroupMapping();
        mapping.setGroupId(groupId);
        mapping.setUsername(username);
        if (Server.dataStore.getUserGroupMappingsDao().storeObject(mapping)) {
            resp.setStatus(200);
        } else {
            resp.sendError(500, "Could not add user to group!");
        }
    }

    @Override
    @JsonContent
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String groupId = req.getPathInfo().replace("/", "");
        JSONObject obj = new JSONObject(req.getReader().lines().collect(Collectors.joining(System.lineSeparator())));
        String username = obj.getString("username");
        StatementElement statementElement1 = new StatementElement("username", "=", username, "AND");
        StatementElement statementElement2 = new StatementElement("groupId", "=", groupId, "");
        StatementList constraint = new StatementList();
        constraint.addStatement(statementElement1);
        constraint.addStatement(statementElement2);
        if (Server.dataStore.getUserGroupMappingsDao().deleteObject(constraint)) {
            resp.setStatus(200);
        } else {
            resp.sendError(500, "Could not delete mapping between user and group!");
        }
    }
}

