/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.core.workflows;

import net.jami.jams.common.dao.StatementElement;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.objects.requests.RevocationRequest;
import net.jami.jams.common.objects.requests.RevocationType;
import net.jami.jams.common.objects.responses.DeviceRevocationResponse;
import net.jami.jams.common.objects.user.User;
import net.jami.jams.server.Server;
import org.bouncycastle.cert.X509CRLHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevokeUserFlow {
    private static final Logger log = LoggerFactory.getLogger(RevokeUserFlow.class);

    public static DeviceRevocationResponse revokeUser(String username) {
        DeviceRevocationResponse response = new DeviceRevocationResponse();
        try {
            StatementList statementList = new StatementList();
            StatementElement st1 = new StatementElement("username", "=", username, "");
            statementList.addStatement(st1);
            User user = (User)Server.dataStore.getUserDao().getObjects(statementList).get(0);
            if (user == null) {
                log.error("Could not find user!");
                return null;
            }
            RevocationRequest request = new RevocationRequest();
            request.setRevocationType(RevocationType.USER);
            request.setIdentifier(user.getCertificate().getSerialNumber());
            Server.certificateAuthority.revokeCertificate(request);
            long statTime = System.currentTimeMillis();
            while (((X509CRLHolder)Server.certificateAuthority.getLatestCRL().get()).getRevokedCertificate(user.getCertificate().getSerialNumber()) == null) {
                log.warn("Certificate has not yet appeared in CRL!");
                if (System.currentTimeMillis() - statTime <= 1000L) continue;
                log.error("The certificate has not appeared within 1 second, we are considering the operation has failed");
                response.setSuccess(false);
                return response;
            }
            response.setSuccess(true);
            return response;
        }
        catch (Exception e) {
            log.error("An exception has occurred while trying to revoke a device with error {}", (Object)e.getMessage());
            response.setSuccess(false);
            response.setErrorDetails(e.getMessage());
            return response;
        }
    }
}

