/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.ldap.connector.service;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.jami.datastore.main.DataStore;
import net.jami.jams.common.dao.StatementElement;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.objects.user.UserProfile;
import net.jami.jams.ldap.connector.LDAPConnector;
import net.jami.jams.server.Server;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserProfileService {
    private static final Logger log = LoggerFactory.getLogger(UserProfileService.class);
    private final ConnectionFactory connectionFactory;

    public UserProfileService(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserProfile> getUserProfile(String queryString, String field, boolean exactMatch, Optional<Integer> page) {
        List<UserProfile> list;
        try (Connection connection = null;){
            List<UserProfile> profilesFromResponse;
            List<UserProfile> list2;
            queryString = new String(queryString.getBytes("UTF-8"), "ISO-8859-1");
            connection = this.connectionFactory.getConnection();
            try {
                Object object;
                connection.open();
                SearchOperation search = new SearchOperation(this.connectionFactory);
                SearchResponse res = search.execute(UserProfileService.buildRequest(queryString, field, exactMatch));
                DataStore.NUM_PAGES = Integer.valueOf(res.getEntries().size()) / DataStore.RESULTS_PER_PAGE;
                if (res.getEntries().size() % DataStore.RESULTS_PER_PAGE != 0) {
                    object = Server.dataStore;
                    list2 = DataStore.NUM_PAGES;
                    DataStore.NUM_PAGES = DataStore.NUM_PAGES + 1;
                }
                if (page.isPresent() && !res.getEntries().isEmpty()) {
                    res = res.getEntries().size() < DataStore.RESULTS_PER_PAGE ? res.subResult(0, res.getEntries().size()) : (page.get() * DataStore.RESULTS_PER_PAGE > res.getEntries().size() ? res.subResult((page.get() - 1) * DataStore.RESULTS_PER_PAGE, res.getEntries().size()) : res.subResult((page.get() - 1) * DataStore.RESULTS_PER_PAGE, page.get() * DataStore.RESULTS_PER_PAGE));
                }
                if (res.getEntries().size() == 0) {
                    object = new ArrayList();
                    return object;
                }
                profilesFromResponse = res.getEntries().stream().map(UserProfileService::profileFromResponse).collect(Collectors.toList());
            }
            catch (Exception e) {
                log.error("Could not search LDAP directory with error " + e.toString());
                list = null;
                return list;
            }
            for (UserProfile p : profilesFromResponse) {
                StatementList statementList = new StatementList();
                StatementElement st = new StatementElement("username", "=", p.getUsername(), "");
                statementList.addStatement(st);
                if (!Server.dataStore.getUserProfileDao().getObjects(statementList).isEmpty()) continue;
                Server.dataStore.getUserProfileDao().storeObject(p);
            }
            list2 = profilesFromResponse;
            return list2;
        }
    }

    public static SearchRequest buildRequest(String queryString, String field, boolean exactMatch) {
        if (!exactMatch) {
            if (!queryString.startsWith("*")) {
                queryString = "*".concat(queryString);
            }
            if (!queryString.endsWith("*")) {
                queryString = queryString.concat("*");
            }
        }
        if (field.equals("LOGON_NAME")) {
            return (SearchRequest)SearchRequest.builder().dn(LDAPConnector.settings.getBaseDN()).filter("(&(uid=" + queryString + "))").build();
        }
        if (field.equals("FULL_TEXT_NAME")) {
            return (SearchRequest)SearchRequest.builder().dn(LDAPConnector.settings.getBaseDN()).filter("(|(givenName=" + queryString + ")(sn=" + queryString + ")").build();
        }
        return null;
    }

    public static UserProfile profileFromResponse(LdapEntry entry) {
        HashMap fieldMap = LDAPConnector.settings.getFieldMappings();
        try {
            UserProfile userProfile = new UserProfile();
            for (String attribute : entry.getAttributeNames()) {
                if (!fieldMap.containsKey(attribute)) continue;
                ((Method)UserProfile.exposedMethods.get("set" + (String)fieldMap.get(attribute))).invoke((Object)userProfile, entry.getAttribute(attribute).getStringValue());
            }
            userProfile.setDefaultValues();
            return userProfile;
        }
        catch (Exception e) {
            log.error("An error occurred while trying to invoke methods: " + e.toString());
            return null;
        }
    }
}

