/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.ldap.connector;

import com.jsoniter.JsonIterator;
import java.util.List;
import java.util.Optional;
import net.jami.jams.common.authentication.AuthenticationSource;
import net.jami.jams.common.authentication.AuthenticationSourceInfo;
import net.jami.jams.common.authentication.AuthenticationSourceType;
import net.jami.jams.common.authentication.ldap.LDAPSettings;
import net.jami.jams.common.objects.user.User;
import net.jami.jams.common.objects.user.UserProfile;
import net.jami.jams.common.serialization.JsoniterRegistry;
import net.jami.jams.ldap.connector.service.AuthenticationService;
import net.jami.jams.ldap.connector.service.UserProfileService;
import org.ldaptive.BindConnectionInitializer;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.Credential;
import org.ldaptive.DefaultConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPConnector
implements AuthenticationSource {
    private static final Logger log = LoggerFactory.getLogger(LDAPConnector.class);
    private final AuthenticationService authenticationService;
    private final UserProfileService userProfileService;
    public static LDAPSettings settings;

    public LDAPConnector(String strSettings) {
        JsoniterRegistry.initCodecs();
        settings = JsonIterator.deserialize(strSettings, LDAPSettings.class);
        BindConnectionInitializer bindConnectionInitializer = new BindConnectionInitializer();
        bindConnectionInitializer.setBindDn(settings.getUsername());
        bindConnectionInitializer.setBindCredential(new Credential(settings.getPassword()));
        ConnectionConfig connConfig = ConnectionConfig.builder().url(settings.getHost()).useStartTLS(settings.getUseStartTLS()).connectionInitializers(bindConnectionInitializer).build();
        this.authenticationService = new AuthenticationService(new DefaultConnectionFactory(connConfig));
        this.userProfileService = new UserProfileService(new DefaultConnectionFactory(connConfig));
        log.info("Started LDAP Connector!");
    }

    public boolean createUser(User user) {
        return false;
    }

    public List<UserProfile> searchUserProfiles(String queryString, String field, Optional<Integer> page) {
        return this.userProfileService.getUserProfile(queryString, field, false, page);
    }

    public UserProfile getUserProfile(String username) {
        List<UserProfile> results = this.userProfileService.getUserProfile(username, "LOGON_NAME", true, Optional.empty());
        if (results == null || results.size() != 1) {
            return null;
        }
        return results.get(0);
    }

    public boolean setUserProfile(UserProfile userProfile) {
        return false;
    }

    public boolean authenticate(String username, String password) {
        return this.authenticationService.authenticateUser(username, password);
    }

    public AuthenticationSourceInfo getInfo() {
        return new AuthenticationSourceInfo(settings.getRealm(), AuthenticationSourceType.LDAP);
    }

    public boolean test() {
        return this.searchUserProfiles("*", "LOGON_NAME", Optional.empty()).size() != 0;
    }

    public boolean updatePassword(User user, String password) {
        return false;
    }
}

