/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.output;

import com.jsoniter.any.Any;
import com.jsoniter.output.JsonStream;
import com.jsoniter.spi.Encoder;
import com.jsoniter.spi.TypeLiteral;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;

class ReflectionListEncoder
implements Encoder.ReflectionEncoder {
    private final TypeLiteral compTypeLiteral;

    public ReflectionListEncoder(Class clazz, Type[] typeArgs) {
        this.compTypeLiteral = typeArgs.length > 0 ? TypeLiteral.create(typeArgs[0]) : TypeLiteral.create(Object.class);
    }

    @Override
    public void encode(Object obj, JsonStream stream) throws IOException {
        if (null == obj) {
            stream.writeNull();
            return;
        }
        List list = (List)obj;
        if (list.isEmpty()) {
            stream.writeEmptyArray();
            return;
        }
        stream.writeArrayStart();
        stream.writeIndention();
        stream.writeVal(this.compTypeLiteral, list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            stream.writeMore();
            stream.writeVal(this.compTypeLiteral, list.get(i));
        }
        stream.writeArrayEnd();
    }

    @Override
    public Any wrap(Object obj) {
        List col = (List)obj;
        return Any.wrap(col);
    }
}

