/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.output;

import com.jsoniter.output.CodegenImplNative;
import com.jsoniter.output.JsonStream;
import com.jsoniter.spi.Encoder;
import com.jsoniter.spi.JsonException;
import com.jsoniter.spi.JsoniterSpi;
import java.io.IOException;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;

class MapKeyEncoders {
    MapKeyEncoders() {
    }

    public static Encoder registerOrGetExisting(Type mapKeyType) {
        String cacheKey = JsoniterSpi.getMapKeyEncoderCacheKey(mapKeyType);
        Encoder mapKeyEncoder = JsoniterSpi.getMapKeyEncoder(cacheKey);
        if (null != mapKeyEncoder) {
            return mapKeyEncoder;
        }
        mapKeyEncoder = MapKeyEncoders.createDefaultEncoder(mapKeyType);
        JsoniterSpi.addNewMapEncoder(cacheKey, mapKeyEncoder);
        return mapKeyEncoder;
    }

    private static Encoder createDefaultEncoder(Type mapKeyType) {
        if (mapKeyType == String.class) {
            return new StringKeyEncoder();
        }
        if (mapKeyType == Object.class) {
            return new DynamicKeyEncoder();
        }
        if (mapKeyType instanceof WildcardType) {
            return new DynamicKeyEncoder();
        }
        if (mapKeyType instanceof Class && ((Class)mapKeyType).isEnum()) {
            return new StringKeyEncoder();
        }
        Encoder.ReflectionEncoder encoder = CodegenImplNative.NATIVE_ENCODERS.get(mapKeyType);
        if (encoder != null) {
            return new NumberKeyEncoder(encoder);
        }
        throw new JsonException("can not encode map key type: " + mapKeyType);
    }

    private static class DynamicKeyEncoder
    implements Encoder {
        private DynamicKeyEncoder() {
        }

        @Override
        public void encode(Object obj, JsonStream stream) throws IOException {
            Class<?> clazz = obj.getClass();
            if (clazz == Object.class) {
                throw new JsonException("map key type is Object.class, can not be encoded");
            }
            Encoder mapKeyEncoder = MapKeyEncoders.registerOrGetExisting(clazz);
            mapKeyEncoder.encode(obj, stream);
        }
    }

    private static class NumberKeyEncoder
    implements Encoder {
        private final Encoder encoder;

        private NumberKeyEncoder(Encoder encoder) {
            this.encoder = encoder;
        }

        @Override
        public void encode(Object obj, JsonStream stream) throws IOException {
            stream.write(34);
            this.encoder.encode(obj, stream);
            stream.write(34);
        }
    }

    private static class StringKeyEncoder
    implements Encoder {
        private StringKeyEncoder() {
        }

        @Override
        public void encode(Object obj, JsonStream stream) throws IOException {
            stream.writeVal(obj);
        }
    }
}

