/*
 * Decompiled with CFR 0.152.
 */
package zmq.util;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.zeromq.ZMQ;
import zmq.Msg;
import zmq.util.Utils;

public class Wire {
    private Wire() {
    }

    private static int getUInt8(ByteBuffer buf, int offset) {
        return buf.get(offset) & 0xFF;
    }

    private static ByteBuffer putUInt8(ByteBuffer buf, int value) {
        buf.put((byte)(value & 0xFF));
        return buf;
    }

    public static int getUInt16(byte[] bytes) {
        return (bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF;
    }

    public static int getUInt16(ByteBuffer buf, int offset) {
        return (buf.get(offset) & 0xFF) << 8 | buf.get(offset + 1) & 0xFF;
    }

    public static byte[] putUInt16(int value) {
        assert (value >= 0);
        byte[] bytes = new byte[]{(byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        return bytes;
    }

    public static Msg putUInt16(Msg msg, int value) {
        msg.put((byte)(value >>> 8 & 0xFF));
        msg.put((byte)(value & 0xFF));
        return msg;
    }

    public static ByteBuffer putUInt16(ByteBuffer buf, int value) {
        buf.put((byte)(value >>> 8 & 0xFF));
        buf.put((byte)(value & 0xFF));
        return buf;
    }

    public static int getUInt32(ByteBuffer buf) {
        return Wire.getUInt32(buf, 0);
    }

    public static int getUInt32(ByteBuffer buf, int offset) {
        return (buf.get(offset) & 0xFF) << 24 | (buf.get(offset + 1) & 0xFF) << 16 | (buf.get(offset + 2) & 0xFF) << 8 | buf.get(offset + 3) & 0xFF;
    }

    public static int getUInt32(Msg msg, int offset) {
        return msg.getInt(offset);
    }

    public static int getUInt32(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    public static ByteBuffer putUInt32(ByteBuffer buf, int value) {
        buf.put((byte)(value >>> 24 & 0xFF));
        buf.put((byte)(value >>> 16 & 0xFF));
        buf.put((byte)(value >>> 8 & 0xFF));
        buf.put((byte)(value & 0xFF));
        return buf;
    }

    public static byte[] putUInt32(int value) {
        assert (value >= 0);
        byte[] bytes = new byte[]{(byte)(value >>> 24 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        return bytes;
    }

    public static Msg putUInt32(Msg msg, int value) {
        msg.put((byte)(value >>> 24 & 0xFF));
        msg.put((byte)(value >>> 16 & 0xFF));
        msg.put((byte)(value >>> 8 & 0xFF));
        msg.put((byte)(value & 0xFF));
        return msg;
    }

    public static ByteBuffer putUInt64(ByteBuffer buf, long value) {
        buf.put((byte)(value >>> 56 & 0xFFL));
        buf.put((byte)(value >>> 48 & 0xFFL));
        buf.put((byte)(value >>> 40 & 0xFFL));
        buf.put((byte)(value >>> 32 & 0xFFL));
        buf.put((byte)(value >>> 24 & 0xFFL));
        buf.put((byte)(value >>> 16 & 0xFFL));
        buf.put((byte)(value >>> 8 & 0xFFL));
        buf.put((byte)(value & 0xFFL));
        return buf;
    }

    public static long getUInt64(ByteBuffer buf, int offset) {
        return (long)(buf.get(offset) & 0xFF) << 56 | (long)(buf.get(offset + 1) & 0xFF) << 48 | (long)(buf.get(offset + 2) & 0xFF) << 40 | (long)(buf.get(offset + 3) & 0xFF) << 32 | (long)(buf.get(offset + 4) & 0xFF) << 24 | (long)(buf.get(offset + 5) & 0xFF) << 16 | (long)(buf.get(offset + 6) & 0xFF) << 8 | (long)buf.get(offset + 7) & 0xFFL;
    }

    public static long getUInt64(Msg msg, int offset) {
        return msg.getLong(offset);
    }

    public static int putShortString(ByteBuffer buf, String value) {
        return Wire.putShortString(ZMQ.CHARSET, buf, value);
    }

    public static String getShortString(ByteBuffer buf, int offset) {
        return Wire.getShortString(ZMQ.CHARSET, buf, offset);
    }

    public static int putShortString(Charset charset, ByteBuffer buf, String value) {
        int length = value.length();
        Utils.checkArgument(length < 256, "String must be strictly smaller than 256 characters");
        Wire.putUInt8(buf, length);
        buf.put(value.getBytes(charset));
        return length + 1;
    }

    public static String getShortString(Charset charset, ByteBuffer buf, int offset) {
        int length = Wire.getUInt8(buf, offset);
        return Wire.extractString(charset, buf, offset, length, 1);
    }

    public static int putLongString(ByteBuffer buf, String value) {
        return Wire.putLongString(ZMQ.CHARSET, buf, value);
    }

    public static String getLongString(ByteBuffer buf, int offset) {
        return Wire.getLongString(ZMQ.CHARSET, buf, offset);
    }

    public static int putLongString(Charset charset, ByteBuffer buf, String value) {
        int length = value.length();
        Utils.checkArgument(length < Integer.MAX_VALUE, "String must be smaller than 2^31-1 characters");
        Wire.putUInt32(buf, length);
        buf.put(value.getBytes(charset));
        return length + 4;
    }

    public static String getLongString(Charset charset, ByteBuffer buf, int offset) {
        int length = Wire.getUInt32(buf, offset);
        return Wire.extractString(charset, buf, offset, length, 4);
    }

    private static String extractString(Charset charset, ByteBuffer buf, int offset, int length, int sizeOfSize) {
        byte[] text = new byte[length];
        int old = buf.position();
        buf.position(offset + sizeOfSize);
        buf.get(text, 0, length);
        buf.position(old);
        return new String(text, charset);
    }
}

