/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.tomcat.util.ExceptionUtils;

public class JDBCRealm
extends RealmBase {
    protected String connectionName = null;
    protected String connectionPassword = null;
    protected String connectionURL = null;
    protected Connection dbConnection = null;
    protected Driver driver = null;
    protected String driverName = null;
    protected PreparedStatement preparedCredentials = null;
    protected PreparedStatement preparedRoles = null;
    protected String roleNameCol = null;
    protected String userCredCol = null;
    protected String userNameCol = null;
    protected String userRoleTable = null;
    protected String userTable = null;

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public void setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public void setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public String getRoleNameCol() {
        return this.roleNameCol;
    }

    public void setRoleNameCol(String roleNameCol) {
        this.roleNameCol = roleNameCol;
    }

    public String getUserCredCol() {
        return this.userCredCol;
    }

    public void setUserCredCol(String userCredCol) {
        this.userCredCol = userCredCol;
    }

    public String getUserNameCol() {
        return this.userNameCol;
    }

    public void setUserNameCol(String userNameCol) {
        this.userNameCol = userNameCol;
    }

    public String getUserRoleTable() {
        return this.userRoleTable;
    }

    public void setUserRoleTable(String userRoleTable) {
        this.userRoleTable = userRoleTable;
    }

    public String getUserTable() {
        return this.userTable;
    }

    public void setUserTable(String userTable) {
        this.userTable = userTable;
    }

    @Override
    public synchronized Principal authenticate(String username, String credentials) {
        for (int numberOfTries = 2; numberOfTries > 0; --numberOfTries) {
            try {
                this.open();
                Principal principal = this.authenticate(this.dbConnection, username, credentials);
                return principal;
            }
            catch (SQLException e) {
                this.containerLog.error(sm.getString("jdbcRealm.exception"), e);
                if (this.dbConnection == null) continue;
                this.close(this.dbConnection);
                continue;
            }
        }
        return null;
    }

    public synchronized Principal authenticate(Connection dbConnection, String username, String credentials) {
        if (username == null || credentials == null) {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace(sm.getString("jdbcRealm.authenticateFailure", username));
            }
            return null;
        }
        String dbCredentials = this.getPassword(username);
        if (dbCredentials == null) {
            this.getCredentialHandler().mutate(credentials);
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace(sm.getString("jdbcRealm.authenticateFailure", username));
            }
            return null;
        }
        boolean validated = this.getCredentialHandler().matches(credentials, dbCredentials);
        if (validated) {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace(sm.getString("jdbcRealm.authenticateSuccess", username));
            }
        } else {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace(sm.getString("jdbcRealm.authenticateFailure", username));
            }
            return null;
        }
        ArrayList<String> roles = this.getRoles(username);
        return new GenericPrincipal(username, roles);
    }

    @Override
    public boolean isAvailable() {
        return this.dbConnection != null;
    }

    protected void close(Connection dbConnection) {
        if (dbConnection == null) {
            return;
        }
        try {
            this.preparedCredentials.close();
        }
        catch (Throwable f) {
            ExceptionUtils.handleThrowable(f);
        }
        this.preparedCredentials = null;
        try {
            this.preparedRoles.close();
        }
        catch (Throwable f) {
            ExceptionUtils.handleThrowable(f);
        }
        this.preparedRoles = null;
        try {
            dbConnection.close();
        }
        catch (SQLException e) {
            this.containerLog.warn(sm.getString("jdbcRealm.close"), e);
        }
        finally {
            this.dbConnection = null;
        }
    }

    protected PreparedStatement credentials(Connection dbConnection, String username) throws SQLException {
        if (this.preparedCredentials == null) {
            StringBuilder sb = new StringBuilder("SELECT ");
            sb.append(this.userCredCol);
            sb.append(" FROM ");
            sb.append(this.userTable);
            sb.append(" WHERE ");
            sb.append(this.userNameCol);
            sb.append(" = ?");
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug("credentials query: " + sb.toString());
            }
            this.preparedCredentials = dbConnection.prepareStatement(sb.toString());
        }
        if (username == null) {
            this.preparedCredentials.setNull(1, 12);
        } else {
            this.preparedCredentials.setString(1, username);
        }
        return this.preparedCredentials;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected synchronized String getPassword(String username) {
        String dbCredentials = null;
        int numberOfTries = 2;
        while (numberOfTries > 0) {
            try {
                this.open();
                PreparedStatement stmt = this.credentials(this.dbConnection, username);
                try (ResultSet rs = stmt.executeQuery();){
                    if (rs.next()) {
                        dbCredentials = rs.getString(1);
                    }
                    this.dbConnection.commit();
                    if (dbCredentials != null) {
                        dbCredentials = dbCredentials.trim();
                    }
                    String string = dbCredentials;
                    return string;
                }
            }
            catch (SQLException e) {
                this.containerLog.error(sm.getString("jdbcRealm.exception"), e);
                if (this.dbConnection != null) {
                    this.close(this.dbConnection);
                }
                --numberOfTries;
            }
        }
        return null;
    }

    @Override
    protected synchronized Principal getPrincipal(String username) {
        return new GenericPrincipal(username, this.getRoles(username));
    }

    /*
     * Loose catch block
     */
    protected ArrayList<String> getRoles(String username) {
        if (this.allRolesMode != RealmBase.AllRolesMode.STRICT_MODE && !this.isRoleStoreDefined()) {
            return null;
        }
        int numberOfTries = 2;
        while (numberOfTries > 0) {
            ArrayList<String> arrayList;
            Throwable throwable;
            ResultSet rs;
            block21: {
                block22: {
                    this.open();
                    PreparedStatement stmt = this.roles(this.dbConnection, username);
                    rs = stmt.executeQuery();
                    throwable = null;
                    ArrayList<String> roleList = new ArrayList<String>();
                    while (rs.next()) {
                        String role = rs.getString(1);
                        if (null == role) continue;
                        roleList.add(role.trim());
                    }
                    arrayList = roleList;
                    if (rs == null) break block21;
                    if (throwable == null) break block22;
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block21;
                }
                rs.close();
            }
            this.dbConnection.commit();
            return arrayList;
            {
                catch (Throwable throwable3) {
                    try {
                        try {
                            try {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (rs != null) {
                                    if (throwable != null) {
                                        try {
                                            rs.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable.addSuppressed(throwable5);
                                        }
                                    } else {
                                        rs.close();
                                    }
                                }
                                throw throwable4;
                            }
                        }
                        catch (Throwable throwable6) {
                            this.dbConnection.commit();
                            throw throwable6;
                        }
                    }
                    catch (SQLException e) {
                        this.containerLog.error(sm.getString("jdbcRealm.exception"), e);
                        if (this.dbConnection != null) {
                            this.close(this.dbConnection);
                        }
                        --numberOfTries;
                    }
                }
            }
        }
        return null;
    }

    protected Connection open() throws SQLException {
        if (this.dbConnection != null) {
            return this.dbConnection;
        }
        if (this.driver == null) {
            try {
                Class<?> clazz = Class.forName(this.driverName);
                this.driver = (Driver)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                ExceptionUtils.handleThrowable(e);
                throw new SQLException(e.getMessage(), e);
            }
        }
        Properties props = new Properties();
        if (this.connectionName != null) {
            props.put("user", this.connectionName);
        }
        if (this.connectionPassword != null) {
            props.put("password", this.connectionPassword);
        }
        this.dbConnection = this.driver.connect(this.connectionURL, props);
        if (this.dbConnection == null) {
            throw new SQLException(sm.getString("jdbcRealm.open.invalidurl", this.driverName, this.connectionURL));
        }
        this.dbConnection.setAutoCommit(false);
        return this.dbConnection;
    }

    protected synchronized PreparedStatement roles(Connection dbConnection, String username) throws SQLException {
        if (this.preparedRoles == null) {
            StringBuilder sb = new StringBuilder("SELECT ");
            sb.append(this.roleNameCol);
            sb.append(" FROM ");
            sb.append(this.userRoleTable);
            sb.append(" WHERE ");
            sb.append(this.userNameCol);
            sb.append(" = ?");
            this.preparedRoles = dbConnection.prepareStatement(sb.toString());
        }
        this.preparedRoles.setString(1, username);
        return this.preparedRoles;
    }

    private boolean isRoleStoreDefined() {
        return this.userRoleTable != null || this.roleNameCol != null;
    }

    @Override
    protected void startInternal() throws LifecycleException {
        try {
            this.open();
        }
        catch (SQLException e) {
            this.containerLog.error(sm.getString("jdbcRealm.open"), e);
        }
        super.startInternal();
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.close(this.dbConnection);
    }
}

