/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.update;

import com.jsoniter.JsonIterator;
import com.jsoniter.any.Any;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.net.ssl.SSLContext;
import net.jami.jams.common.updater.FileDescription;
import net.jami.jams.common.utils.X509Utils;
import net.jami.jams.server.licensing.LicenseService;
import net.jami.jams.server.update.JAMSUpdater;
import net.jami.jams.server.update.UpdateCheckTask;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateDownloader {
    private static final Logger log = LoggerFactory.getLogger(UpdateDownloader.class);
    private SSLContext sslContext;
    private static final String KEYSTORE_TYPE = "JKS";
    private KeyStore trustStore;
    private static volatile String UPDATE_SERVER_URL;
    private HashMap<String, FileDescription> remoteChecksums = new HashMap();

    public UpdateDownloader() {
        try {
            InputStream is = UpdateCheckTask.class.getClassLoader().getResourceAsStream("oem/ca.crt");
            X509Certificate certificate = X509Utils.getCertificateFromPEMString(new String(is.readAllBytes()));
            this.trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            this.trustStore.load(null, null);
            this.trustStore.setCertificateEntry("ca", certificate);
        }
        catch (Exception e) {
            log.info("Could not load SFL's CA - this should not happen! detailed error: {}", (Object)e.getMessage());
        }
        try {
            InputStream input = this.getClass().getClassLoader().getResourceAsStream("oem/config.json");
            Any any = JsonIterator.deserialize(input.readAllBytes());
            UPDATE_SERVER_URL = any.get((Object)"UPDATE_URL").toString();
        }
        catch (IOException e) {
            log.warn("Missing OEM configuration! Please contact software developer");
            System.exit(-1);
        }
    }

    public boolean downloadFiles(HashMap<String, FileDescription> files) {
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance(KEYSTORE_TYPE);
            ks.load(null);
            LicenseService licenseService = new LicenseService();
            licenseService.loadLicense();
            ks.setKeyEntry("licenses", JAMSUpdater.privateKey, "".toCharArray(), new Certificate[]{JAMSUpdater.certificate});
            this.sslContext = SSLContexts.custom().loadKeyMaterial(ks, "".toCharArray()).loadTrustMaterial(this.trustStore, null).build();
        }
        catch (Exception e) {
            log.warn("Could not download an update with error " + e.toString());
        }
        File tmpFolder = new File(System.getProperty("user.dir") + "/tmp/");
        if (!tmpFolder.mkdirs()) {
            log.error("Could not create temporary folder to store the update files!");
            return false;
        }
        files.forEach((k, v) -> {
            try {
                CloseableHttpClient httpClient = HttpClients.custom().setSSLContext(this.sslContext).build();
                HttpResponse httpResponse = httpClient.execute(new HttpGet(UPDATE_SERVER_URL + "/updates/" + v.getFileName()));
                if (httpResponse.getStatusLine().getStatusCode() != 200) {
                    return;
                }
                FileOutputStream fos = new FileOutputStream(tmpFolder.getPath() + "/" + v.getFileName());
                httpResponse.getEntity().writeTo(fos);
                fos.close();
            }
            catch (Exception e1) {
                log.warn("Could not download an update with error " + e1.toString());
            }
        });
        return true;
    }
}

