/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.filters;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import net.jami.jams.server.servlets.filters.FilterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebFilter(value={"/api/install/*"})
public class InstallFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(InstallFilter.class);

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (Server.isInstalled.get()) {
            TomcatCustomErrorHandler.sendCustomError(response, 404, "The server is already installed");
        } else {
            boolean authsuccess = false;
            boolean isLogin = false;
            if (request.getServletPath().contains("start")) {
                isLogin = true;
            } else {
                authsuccess = FilterUtils.doAuthCheck(request);
            }
            if (authsuccess || isLogin) {
                filterChain.doFilter(servletRequest, servletResponse);
            } else {
                TomcatCustomErrorHandler.sendCustomError(response, 401, "You are not authenticated!");
            }
        }
    }
}

