/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.auth.directory;

import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import net.jami.datastore.main.DataStore;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.authentication.AuthenticationSource;
import net.jami.jams.common.authentication.AuthenticationSourceType;
import net.jami.jams.common.authmodule.AuthModuleKey;
import net.jami.jams.common.dao.StatementElement;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.objects.user.User;
import net.jami.jams.common.objects.user.UserProfile;
import net.jami.jams.server.Server;
import org.json.JSONObject;

@WebServlet(value={"/api/auth/directory/search"})
public class SearchDirectoryServlet
extends HttpServlet {
    List<UserProfile> userProfiles = new ArrayList<UserProfile>();

    @Override
    @JsonContent
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Optional<Object> page = req.getParameter("page") == null ? Optional.empty() : Optional.ofNullable(Integer.parseInt(req.getParameter("page")));
        ConcurrentHashMap<AuthModuleKey, AuthenticationSource> authSources = new ConcurrentHashMap<AuthModuleKey, AuthenticationSource>(Server.userAuthenticationModule.getAuthSources());
        if (authSources.size() > 1) {
            authSources.forEach((k, v) -> {
                if (k.getType() == AuthenticationSourceType.LOCAL) {
                    authSources.remove(k);
                }
            });
        }
        authSources.forEach((k, v) -> {
            if (req.getParameter("queryString").equals("*")) {
                this.userProfiles = v.searchUserProfiles(req.getParameter("queryString"), "FULL_TEXT_NAME", page);
            } else {
                this.userProfiles = v.searchUserProfiles(req.getParameter("queryString"), "FULL_TEXT_NAME", page);
                if (this.userProfiles.isEmpty() && this.userProfiles.addAll(v.searchUserProfiles(req.getParameter("queryString"), "LOGON_NAME", page))) {
                    TreeSet<UserProfile> s = new TreeSet<UserProfile>(new Comparator<UserProfile>(){

                        @Override
                        public int compare(UserProfile o1, UserProfile o2) {
                            if (o1.getUsername().equals(o2.getUsername())) {
                                return 0;
                            }
                            return 1;
                        }
                    });
                    s.addAll(this.userProfiles);
                    this.userProfiles = new ArrayList<UserProfile>(s);
                }
            }
            this.userProfiles.parallelStream().forEach(profile -> {
                StatementList statementList = new StatementList();
                StatementElement statementElement = new StatementElement("username", "=", profile.getUsername(), "");
                statementList.addStatement(statementElement);
                List<Object> results = new ArrayList();
                while (results.size() == 0) {
                    results = Server.dataStore.getUserDao().getObjects(statementList);
                    if (results.size() == 0) {
                        User user = new User();
                        user.setUsername(profile.getUsername());
                        user.setRealm(k.getRealm());
                        user.setUserType(k.getType());
                        user.setAccessLevel(AccessLevel.USER);
                        Server.userAuthenticationModule.createUser(user.getUserType(), user.getRealm(), Server.nameServer, user);
                        continue;
                    }
                    profile.setId(((User)results.get(0)).getJamiId());
                }
            });
        });
        JSONObject obj = new JSONObject();
        obj.put("profiles", this.userProfiles);
        obj.put("numPages", DataStore.NUM_PAGES);
        if (!this.userProfiles.isEmpty()) {
            resp.getOutputStream().write(obj.toString().getBytes());
            resp.setStatus(200);
        } else {
            resp.setStatus(204, "No users were found!");
        }
    }
}

