/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.admin.users;

import com.jsoniter.output.JsonStream;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.stream.Collectors;
import net.jami.jams.authmodule.PasswordUtil;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.authentication.AuthenticationSourceType;
import net.jami.jams.common.dao.StatementElement;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.objects.responses.DeviceRevocationResponse;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.objects.user.User;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import net.jami.jams.server.core.workflows.RevokeUserFlow;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONObject;

@WebServlet(value={"/api/admin/user"})
public class UserServlet
extends HttpServlet {
    @Override
    @JsonContent
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
        StatementList statementList = new StatementList();
        StatementElement st1 = new StatementElement("username", "=", req.getParameter("username"), "");
        statementList.addStatement(st1);
        if (!Server.dataStore.getUserDao().getObjects(statementList).isEmpty()) {
            User user = (User)Server.dataStore.getUserDao().getObjects(statementList).get(0);
            if (Server.certificateAuthority.getLatestCRL().get() != null) {
                user.setRevoked(Server.certificateAuthority.getLatestCRL().get().getRevokedCertificate(user.getCertificate().getSerialNumber()) != null);
            } else {
                user.setRevoked(false);
            }
            if (!user.getNeedsPasswordReset().booleanValue() && req.getParameter("needPW") != null) {
                String pw = PasswordUtil.hashPassword(req.getParameter("password"), Base64.decodeBase64(user.getSalt()));
                StatementList update = new StatementList();
                StatementElement st0 = new StatementElement("password", "=", pw, "");
                update.addStatement(st0);
                StatementList constraint = new StatementList();
                StatementElement st = new StatementElement("username", "=", req.getParameter("username"), "");
                constraint.addStatement(st);
                StatementElement st2 = new StatementElement("needsPasswordReset", "=", "true", "");
                update.addStatement(st2);
                Server.dataStore.getUserDao().updateObject(update, constraint);
                user = (User)Server.dataStore.getUserDao().getObjects(statementList).get(0);
            }
            user.setPassword("");
            user.setSalt("");
            resp.getOutputStream().write(JsonStream.serialize(user).getBytes());
            resp.setStatus(200);
        } else {
            resp.sendError(404, "Could not obtain user!");
        }
    }

    @Override
    @JsonContent
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
        JSONObject obj = new JSONObject(req.getReader().lines().collect(Collectors.joining(System.lineSeparator())));
        String pw = obj.getString("password");
        if (!pw.isEmpty()) {
            User user = new User();
            user.setUsername(obj.getString("username"));
            user.setNeedsPasswordReset(true);
            byte[] salt = PasswordUtil.generateSalt();
            pw = PasswordUtil.hashPassword(pw, salt);
            user.setPassword(pw);
            user.setSalt(Base64.encodeBase64String(salt));
            user.setRealm("LOCAL");
            user.setUserType(AuthenticationSourceType.LOCAL);
            if (Server.userAuthenticationModule.createUser(user.getUserType(), user.getRealm(), Server.nameServer, user)) {
                HashMap<String, String> statusInfo = new HashMap<String, String>();
                statusInfo.put("password", pw);
                resp.getOutputStream().write(JsonStream.serialize(statusInfo).getBytes());
                resp.setStatus(200);
                return;
            }
        }
        resp.sendError(500, "Could not create a user successfully!");
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
        JSONObject obj = new JSONObject(req.getReader().lines().collect(Collectors.joining(System.lineSeparator())));
        String pw = obj.getString("password");
        String username = obj.getString("username");
        StatementList statementList = new StatementList();
        StatementElement st0 = new StatementElement("username", "=", username, "");
        statementList.addStatement(st0);
        if (Server.dataStore.getUserDao().getObjects(statementList).isEmpty()) {
            resp.sendError(404, "User was not found!");
            return;
        }
        User user = (User)Server.dataStore.getUserDao().getObjects(statementList).get(0);
        if (user.getUserType() != AuthenticationSourceType.LOCAL) {
            resp.sendError(500, "The user is not a local user, therefore we cannot change his data!");
            return;
        }
        byte[] salt = PasswordUtil.generateSalt();
        StatementList update = new StatementList();
        StatementElement st1 = new StatementElement("password", "=", PasswordUtil.hashPassword(pw, salt), "");
        update.addStatement(st1);
        StatementElement st2 = new StatementElement("salt", "=", Base64.encodeBase64String(salt), "");
        update.addStatement(st2);
        StatementList constraint = new StatementList();
        StatementElement st3 = new StatementElement("username", "=", username, "");
        constraint.addStatement(st3);
        if (Server.dataStore.getUserDao().updateObject(update, constraint)) {
            resp.setStatus(200);
        } else {
            resp.sendError(500, "could not update the users's data field!");
        }
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
        DeviceRevocationResponse devResponse = RevokeUserFlow.revokeUser(req.getParameter("username"));
        if (devResponse != null && devResponse.isSuccess()) {
            resp.getOutputStream().write(JsonStream.serialize(devResponse).getBytes());
        } else {
            resp.sendError(500, "An exception has occurred while trying to revoke a user!");
        }
    }
}

