/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.admin.users;

import com.jsoniter.output.JsonStream;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.dao.StatementElement;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/admin/user/groups/*"})
public class UserGroupsServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(UserGroupsServlet.class);

    @Override
    @JsonContent
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)((Object)req.getAttribute("accessLevel"));
        if (accessLevel == AccessLevel.valueOf("ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError(resp, 403, "You do not have sufficient permissions to access this resource!");
            return;
        }
        String username = req.getPathInfo().replace("/", "");
        StatementList statementList = new StatementList();
        StatementElement st = new StatementElement("username", "=", username, "");
        statementList.addStatement(st);
        List result = Server.dataStore.getUserGroupMappingsDao().getObjects(statementList);
        if (result.isEmpty()) {
            resp.sendError(404, "No groups found for this user!");
        } else {
            resp.getOutputStream().write(JsonStream.serialize(result).getBytes());
            resp.setStatus(200);
        }
    }
}

