/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.core.workflows;

import java.security.cert.X509Certificate;
import java.util.Optional;
import net.jami.jams.common.authmodule.AuthModuleKey;
import net.jami.jams.common.dao.StatementElement;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.objects.devices.Device;
import net.jami.jams.common.objects.requests.DeviceRegistrationRequest;
import net.jami.jams.common.objects.responses.DeviceRegistrationResponse;
import net.jami.jams.common.objects.user.Group;
import net.jami.jams.common.objects.user.Policy;
import net.jami.jams.common.objects.user.User;
import net.jami.jams.common.objects.user.UserGroupMapping;
import net.jami.jams.common.objects.user.UserProfile;
import net.jami.jams.dht.DeviceReceiptGenerator;
import net.jami.jams.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterDeviceFlow {
    private static final Logger log = LoggerFactory.getLogger(RegisterDeviceFlow.class);

    public static DeviceRegistrationResponse registerDevice(String username, DeviceRegistrationRequest registrationRequest) {
        try {
            StatementList statementList = new StatementList();
            statementList.addStatement(new StatementElement("username", "=", username, ""));
            User user = (User)Server.dataStore.getUserDao().getObjects(statementList).get(0);
            UserProfile userProfile = Server.userAuthenticationModule.getAuthSources().get(new AuthModuleKey(user.getRealm(), user.getUserType())).searchUserProfiles(username, "LOGON_NAME", Optional.empty()).get(0);
            if (user == null) {
                log.error("Tried to enroll a device, but could not find a user, this is impossible!");
            }
            Device device = new Device();
            device.setCertificationRequest(registrationRequest.getCsr());
            device.setOwner(username);
            device.setDisplayName(registrationRequest.getDeviceName());
            device = Server.certificateAuthority.getSignedCertificate(user, device);
            if (device == null) {
                log.error("Could not succesfully create a device certificate!");
                return null;
            }
            Server.dataStore.getDeviceDao().storeObject(device);
            Group group = new Group();
            statementList = new StatementList();
            statementList.addStatement(new StatementElement("username", "=", username, ""));
            if (Server.dataStore.getUserGroupMappingsDao().getObjects(statementList) != null && !Server.dataStore.getUserGroupMappingsDao().getObjects(statementList).isEmpty()) {
                UserGroupMapping mapping = (UserGroupMapping)Server.dataStore.getUserGroupMappingsDao().getObjects(statementList).get(0);
                statementList = new StatementList();
                statementList.addStatement(new StatementElement("id", "=", mapping.getGroupId(), ""));
                group = (Group)Server.dataStore.getGroupDao().getObjects(statementList).get(0);
            }
            DeviceRegistrationResponse response = new DeviceRegistrationResponse();
            if (!group.isEmpty() && group.hasBlueprint()) {
                StatementElement st2 = new StatementElement("name", "=", group.getBlueprint(), "");
                StatementList statementList2 = new StatementList();
                statementList2.addStatement(st2);
                try {
                    Policy policy = (Policy)Server.dataStore.getPolicyDao().getObjects(statementList2).get(0);
                    response.setPolicyData(policy.getPolicyData());
                }
                catch (Exception e1) {
                    log.warn("No policy available for user - not adding a policy component to response");
                }
            }
            String[] devReceipt = DeviceReceiptGenerator.generateReceipt(user.getPrivateKey(), user.getCertificate().getPublicKey(), device.getCertificate().getPublicKey(), user.getEthAddress());
            response.setDeviceReceipt(devReceipt[0]);
            response.setReceiptSignature(devReceipt[1]);
            response.setDisplayName(userProfile.getFirstName() + " " + userProfile.getLastName());
            response.setNameServer(Server.nameServer.getURI());
            if (userProfile.getProfilePicture() != null) {
                response.setUserPhoto(userProfile.getProfilePicture());
            }
            response.setCertificateChain(new X509Certificate[]{Server.certificateAuthority.getCA(), user.getCertificate(), device.getCertificate()});
            return response;
        }
        catch (Exception e) {
            log.error("An exception has occurred while trying to enroll a device with error {}", (Object)e.getMessage());
            return null;
        }
    }
}

