/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.common.utils;

import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import net.jami.jams.common.updater.FileDescription;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersioningUtils {
    private static final Logger log = LoggerFactory.getLogger(VersioningUtils.class);

    public static HashMap<String, FileDescription> checkVersion(String baseLocation) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            HashMap<String, FileDescription> res = new HashMap<String, FileDescription>();
            ArrayList<Path> files = new ArrayList<Path>();
            if (baseLocation == null) {
                baseLocation = System.getProperty("user.dir");
            }
            Stream<Path> stream = Files.walk(Paths.get(baseLocation, new String[0]), new FileVisitOption[0]);
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(files::add);
            stream.close();
            files.forEach(e -> {
                String fileName = e.toString();
                if (fileName.endsWith(".jar")) {
                    try {
                        JarFile file = new JarFile(e.toFile());
                        String version = file.getManifest().getMainAttributes().getValue("Implementation-Version");
                        String className = file.getManifest().getMainAttributes().getValue("Main-Class");
                        String md5 = Hex.toHexString(messageDigest.digest(Files.readAllBytes(e.toAbsolutePath())));
                        String[] arr = e.toString().split(File.separator);
                        res.put(arr[arr.length - 1], new FileDescription(arr[arr.length - 1], version, md5, className));
                        log.info("Found version {} of {}", (Object)version, (Object)fileName);
                    }
                    catch (Exception e1) {
                        log.error("Could detect version for file with error {}", (Object)e1.getMessage());
                    }
                }
            });
            return res;
        }
        catch (Exception e2) {
            log.error("An error has occurred while trying to list file versions {}", (Object)e2.getMessage());
            return null;
        }
    }
}

