/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.common.serialization.serializers;

import com.jsoniter.JsonIterator;
import com.jsoniter.any.Any;
import com.jsoniter.output.JsonStream;
import com.jsoniter.spi.Decoder;
import com.jsoniter.spi.Encoder;
import java.io.IOException;
import net.jami.jams.common.objects.contacts.Contact;

public class ContactCodec
implements Encoder,
Decoder {
    @Override
    public Object decode(JsonIterator jsonIterator) throws IOException {
        Any input = jsonIterator.readAny();
        Contact contact = new Contact();
        contact.setUri(input.get((Object)"uri").toString());
        long timeAdded = 0L;
        long timeRemoved = 0L;
        if (!input.get((Object)"added").toString().isBlank()) {
            timeAdded = input.get((Object)"added").toLong();
        }
        if (!input.get((Object)"removed").toString().isBlank()) {
            timeRemoved = input.get((Object)"removed").toLong();
        }
        if (timeAdded >= timeRemoved) {
            contact.setStatus(Character.valueOf('A'));
            contact.setTimestamp(input.get((Object)"added").toLong());
        } else {
            contact.setStatus(Character.valueOf('D'));
            contact.setTimestamp(input.get((Object)"removed").toLong());
        }
        if (!input.get((Object)"banned").toString().isBlank()) {
            contact.setBanned(input.get((Object)"banned").as(Boolean.class));
        }
        if (!input.get((Object)"confirmed").toString().isBlank()) {
            contact.setConfirmed(input.get((Object)"confirmed").as(Boolean.class));
        }
        return contact;
    }

    @Override
    public void encode(Object o, JsonStream jsonStream) throws IOException {
        Contact ct = (Contact)o;
        StringBuilder sb = new StringBuilder();
        sb.append("{\"uri\":\"").append(ct.getUri()).append("\",");
        switch (ct.getStatus().charValue()) {
            case 'A': {
                sb.append("\"added\":").append(ct.getTimestamp());
                sb.append(",");
                sb.append("\"confirmed\":").append(ct.getConfirmed());
                break;
            }
            case 'D': {
                sb.append("\"removed\":").append(ct.getTimestamp());
                if (!ct.getBanned().booleanValue()) break;
                sb.append(",").append("\"banned\":").append(ct.getBanned());
            }
        }
        sb.append("}");
        jsonStream.write(sb.toString().getBytes());
    }
}

