/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.common.objects.user;

import com.jsoniter.annotation.JsonIgnore;
import ezvcard.Ezvcard;
import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.parameter.EmailType;
import ezvcard.parameter.ImageType;
import ezvcard.parameter.TelephoneType;
import ezvcard.property.Photo;
import ezvcard.property.StructuredName;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import net.jami.jams.common.serialization.database.DatabaseObject;
import org.bouncycastle.util.encoders.Base64;

public class UserProfile
implements DatabaseObject {
    public static HashMap<String, Method> exposedMethods = new HashMap();
    private String username;
    private String firstName;
    private String lastName;
    private String email;
    private String profilePicture;
    private String organization;
    private String phoneNumber;
    private String phoneNumberExtension;
    private String faxNumber;
    private String mobileNumber;
    private String id;

    public UserProfile(ResultSet rs) throws Exception {
        this.username = rs.getString("username");
        this.firstName = rs.getString("firstName");
        this.lastName = rs.getString("lastName");
        this.email = rs.getString("email");
        this.profilePicture = rs.getString("profilePicture");
        this.organization = rs.getString("organization");
        this.phoneNumber = rs.getString("phoneNumber");
        this.phoneNumberExtension = rs.getString("phoneNumberExtension");
        this.faxNumber = rs.getString("faxNumber");
        this.mobileNumber = rs.getString("mobileNumber");
    }

    @JsonIgnore
    public String getAsVCard() {
        VCard vCard = new VCard();
        StructuredName structuredName = new StructuredName();
        structuredName.setFamily(URLEncoder.encode(this.getLastName(), StandardCharsets.UTF_8));
        structuredName.setGiven(URLEncoder.encode(this.getFirstName(), StandardCharsets.UTF_8));
        vCard.setStructuredName(structuredName);
        if (this.getPhoneNumber() != null) {
            vCard.addTelephoneNumber(this.getPhoneNumber(), TelephoneType.WORK);
        }
        if (this.getMobileNumber() != null) {
            vCard.addTelephoneNumber(this.getMobileNumber(), TelephoneType.CELL);
        }
        if (this.getFaxNumber() != null) {
            vCard.addTelephoneNumber(this.getFaxNumber(), TelephoneType.FAX);
        }
        if (this.getEmail() != null) {
            vCard.addEmail(this.getEmail(), EmailType.WORK);
        }
        if (this.getOrganization() != null) {
            vCard.setOrganization(this.getOrganization());
        }
        if (this.getId() != null) {
            vCard.setExtendedProperty("id", this.id);
        }
        if (this.getProfilePicture() != null) {
            Photo photo = new Photo(Base64.decode(this.getProfilePicture()), ImageType.JPEG);
            vCard.addPhoto(photo);
        }
        return Ezvcard.write(vCard).version(VCardVersion.V3_0).go();
    }

    @Override
    public PreparedStatement getInsert(PreparedStatement ps) throws Exception {
        ps.setString(1, this.username);
        ps.setString(2, this.firstName);
        ps.setString(3, this.lastName);
        ps.setString(4, this.email);
        ps.setString(5, this.profilePicture);
        ps.setString(6, this.organization);
        ps.setString(7, this.phoneNumber);
        ps.setString(8, this.phoneNumberExtension);
        ps.setString(9, this.faxNumber);
        ps.setString(10, this.mobileNumber);
        return ps;
    }

    @Override
    public PreparedStatement getDelete(PreparedStatement ps) throws Exception {
        return null;
    }

    @Override
    public PreparedStatement getUpdate(PreparedStatement ps) throws Exception {
        return null;
    }

    public boolean equals(Object obj) {
        UserProfile profile = (UserProfile)obj;
        return profile.getUsername().equals(this.username) && profile.getFirstName().equals(this.firstName) && profile.getLastName().equals(this.lastName);
    }

    public void setDefaultValues() {
        if (this.firstName == null) {
            this.firstName = "";
        }
        if (this.lastName == null) {
            this.lastName = "";
        }
        if (this.email == null) {
            this.email = "";
        }
        if (this.profilePicture == null) {
            this.profilePicture = "";
        }
        if (this.organization == null) {
            this.organization = "";
        }
        if (this.phoneNumber == null) {
            this.phoneNumber = "";
        }
        if (this.phoneNumberExtension == null) {
            this.phoneNumberExtension = "";
        }
        if (this.faxNumber == null) {
            this.faxNumber = "";
        }
        if (this.mobileNumber == null) {
            this.mobileNumber = "";
        }
    }

    public UserProfile(String username, String firstName, String lastName, String email, String profilePicture, String organization, String phoneNumber, String phoneNumberExtension, String faxNumber, String mobileNumber, String id) {
        this.username = username;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.profilePicture = profilePicture;
        this.organization = organization;
        this.phoneNumber = phoneNumber;
        this.phoneNumberExtension = phoneNumberExtension;
        this.faxNumber = faxNumber;
        this.mobileNumber = mobileNumber;
        this.id = id;
    }

    public UserProfile() {
    }

    public String getUsername() {
        return this.username;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getProfilePicture() {
        return this.profilePicture;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getPhoneNumberExtension() {
        return this.phoneNumberExtension;
    }

    public String getFaxNumber() {
        return this.faxNumber;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public String getId() {
        return this.id;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setProfilePicture(String profilePicture) {
        this.profilePicture = profilePicture;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public void setPhoneNumberExtension(String phoneNumberExtension) {
        this.phoneNumberExtension = phoneNumberExtension;
    }

    public void setFaxNumber(String faxNumber) {
        this.faxNumber = faxNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public void setId(String id) {
        this.id = id;
    }

    static {
        for (Method method : UserProfile.class.getMethods()) {
            exposedMethods.put(method.getName(), method);
        }
    }
}

