/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.common.objects.user;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import net.jami.jams.common.authentication.AuthenticationSourceType;
import net.jami.jams.common.objects.roots.BlockchainEntity;
import net.jami.jams.common.objects.roots.X509Entity;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.serialization.database.DatabaseObject;
import net.jami.jams.common.utils.X509Utils;

public class User
extends X509Entity
implements BlockchainEntity,
DatabaseObject {
    private String username;
    private String password;
    private AuthenticationSourceType userType;
    private String realm;
    private AccessLevel accessLevel = AccessLevel.USER;
    private Boolean needsPasswordReset = false;
    private String salt;
    private String ethAddress;
    private String ethKey;
    private String jamiId;

    public User(ResultSet rs) throws Exception {
        this.username = rs.getString("username");
        this.password = rs.getString("password");
        this.userType = AuthenticationSourceType.valueOf(rs.getString("userType"));
        this.accessLevel = AccessLevel.valueOf(rs.getString("accessLevel"));
        this.needsPasswordReset = Boolean.parseBoolean(rs.getString("needsPasswordReset"));
        this.salt = rs.getString("salt");
        this.realm = rs.getString("realm");
        this.ethAddress = rs.getString("ethAddress");
        this.ethKey = rs.getString("ethKey");
        this.jamiId = rs.getString("jamiId");
        if (rs.getString("certificate") != null && !rs.getString("certificate").isBlank()) {
            this.setCertificate(X509Utils.getCertificateFromPEMString(rs.getString("certificate")));
        }
        if (rs.getString("privatekey") != null && !rs.getString("privatekey").isBlank()) {
            this.setPrivateKey(X509Utils.getKeyFromPEMString(rs.getString("privatekey")));
        }
    }

    @Override
    public String getAddress() {
        return this.ethAddress;
    }

    @Override
    public void setAddress(String address) {
        this.ethAddress = address;
    }

    @Override
    public String getKey() {
        return this.ethKey;
    }

    @Override
    public void setKey(String key) {
        this.ethKey = key;
    }

    @Override
    public PreparedStatement getInsert(PreparedStatement ps) throws Exception {
        ps.setString(1, this.username);
        if (this.userType != null && this.userType.equals((Object)AuthenticationSourceType.LOCAL)) {
            ps.setString(2, this.password);
        } else {
            ps.setString(2, null);
        }
        if (this.userType != null) {
            ps.setString(3, this.userType.toString());
        } else {
            ps.setString(3, null);
        }
        ps.setString(4, this.realm);
        ps.setString(5, this.ethAddress);
        ps.setString(6, this.ethKey);
        ps.setString(7, this.jamiId);
        if (this.getCertificate() != null) {
            ps.setString(8, X509Utils.getPEMStringFromCertificate(this.getCertificate()));
        } else {
            ps.setString(8, "");
        }
        if (this.getPrivateKey() != null) {
            ps.setString(9, X509Utils.getPEMStringFromPrivateKey(this.getPrivateKey()));
        } else {
            ps.setString(9, "");
        }
        ps.setString(10, this.accessLevel.toString());
        ps.setString(11, this.needsPasswordReset.toString());
        ps.setString(12, this.salt);
        return ps;
    }

    @Override
    public PreparedStatement getDelete(PreparedStatement ps) throws Exception {
        return null;
    }

    @Override
    public PreparedStatement getUpdate(PreparedStatement ps) throws Exception {
        return null;
    }

    public void setPassword(char[] password) {
        this.password = new String(password);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public User(String username, String password, AuthenticationSourceType userType, String realm, AccessLevel accessLevel, Boolean needsPasswordReset, String salt, String ethAddress, String ethKey, String jamiId) {
        this.username = username;
        this.password = password;
        this.userType = userType;
        this.realm = realm;
        this.accessLevel = accessLevel;
        this.needsPasswordReset = needsPasswordReset;
        this.salt = salt;
        this.ethAddress = ethAddress;
        this.ethKey = ethKey;
        this.jamiId = jamiId;
    }

    public User() {
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public AuthenticationSourceType getUserType() {
        return this.userType;
    }

    public String getRealm() {
        return this.realm;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public Boolean getNeedsPasswordReset() {
        return this.needsPasswordReset;
    }

    public String getSalt() {
        return this.salt;
    }

    public String getEthAddress() {
        return this.ethAddress;
    }

    public String getEthKey() {
        return this.ethKey;
    }

    public String getJamiId() {
        return this.jamiId;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setUserType(AuthenticationSourceType userType) {
        this.userType = userType;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void setAccessLevel(AccessLevel accessLevel) {
        this.accessLevel = accessLevel;
    }

    public void setNeedsPasswordReset(Boolean needsPasswordReset) {
        this.needsPasswordReset = needsPasswordReset;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public void setEthAddress(String ethAddress) {
        this.ethAddress = ethAddress;
    }

    public void setEthKey(String ethKey) {
        this.ethKey = ethKey;
    }

    public void setJamiId(String jamiId) {
        this.jamiId = jamiId;
    }
}

