/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.common.objects.system;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import net.jami.jams.common.objects.roots.X509Entity;
import net.jami.jams.common.objects.system.SystemAccountType;
import net.jami.jams.common.serialization.database.DatabaseObject;
import net.jami.jams.common.utils.X509Utils;

public class SystemAccount
extends X509Entity
implements DatabaseObject {
    private SystemAccountType systemAccountType;

    public SystemAccount(ResultSet rs) throws Exception {
        this.systemAccountType = SystemAccountType.valueOf(rs.getString("entity"));
        this.setCertificate(X509Utils.getCertificateFromPEMString(rs.getString("certificate")));
        this.setPrivateKey(X509Utils.getKeyFromPEMString(rs.getString("privatekey")));
    }

    @Override
    public PreparedStatement getInsert(PreparedStatement ps) throws Exception {
        ps.setString(1, this.systemAccountType.toString());
        ps.setString(2, X509Utils.getPEMStringFromCertificate(this.getCertificate()));
        ps.setString(3, X509Utils.getPEMStringFromPrivateKey(this.getPrivateKey()));
        return ps;
    }

    @Override
    public PreparedStatement getDelete(PreparedStatement ps) throws Exception {
        return null;
    }

    @Override
    public PreparedStatement getUpdate(PreparedStatement ps) throws Exception {
        return null;
    }

    public SystemAccountType getSystemAccountType() {
        return this.systemAccountType;
    }

    public void setSystemAccountType(SystemAccountType systemAccountType) {
        this.systemAccountType = systemAccountType;
    }

    public SystemAccount() {
    }
}

