/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.common.dao.connectivity;

import java.sql.DriverManager;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.jami.jams.common.dao.connectivity.SQLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPool {
    private static final Logger log = LoggerFactory.getLogger(ConnectionPool.class);
    private final ConcurrentLinkedQueue<SQLConnection> connections = new ConcurrentLinkedQueue();
    private String connectionURI;

    public ConnectionPool(String connectionURI) {
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
            this.connectionURI = connectionURI;
            while (this.connections.size() < 10) {
                try {
                    this.connections.add(new SQLConnection(DriverManager.getConnection(connectionURI)));
                }
                catch (Exception e) {
                    log.error("Could not create a link with the database: " + e.toString());
                }
            }
        }
        catch (Exception e) {
            log.error("Could not load ApacheDerby class driver: " + e.toString());
        }
    }

    public SQLConnection getConnection() {
        try {
            SQLConnection sqlConnection = null;
            while (sqlConnection == null) {
                sqlConnection = this.connections.poll();
            }
            if (sqlConnection.isStale()) {
                sqlConnection = new SQLConnection(DriverManager.getConnection(this.connectionURI));
            }
            return sqlConnection;
        }
        catch (Exception e) {
            log.info("A connection could not be obtained with error " + e.toString());
            return null;
        }
    }

    public void returnConnection(SQLConnection sqlConnection) {
        try {
            if (sqlConnection.isStale()) {
                sqlConnection.getConnection().close();
                sqlConnection = new SQLConnection(DriverManager.getConnection(this.connectionURI));
            }
            this.connections.add(sqlConnection);
        }
        catch (Exception e) {
            log.error("Could not return a connection!");
        }
    }
}

