/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.common.dao;

import java.sql.PreparedStatement;
import net.jami.jams.common.dao.StatementElement;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.dao.connectivity.SQLConnection;

public class UpdateStatementBuilder {
    public static PreparedStatement buildStatement(String table, StatementList updateElements, StatementList conditionalElements, SQLConnection connection) throws Exception {
        PreparedStatement ps = null;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UPDATE ").append(table).append(" SET ");
        for (int i = 0; i < updateElements.getStatements().size(); ++i) {
            StatementElement statementElement = updateElements.getStatements().get(i);
            stringBuilder.append(statementElement.getColumn()).append(" = ").append("?");
            if (i == updateElements.getStatements().size() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(" WHERE ");
        for (StatementElement statementElement : conditionalElements.getStatements()) {
            stringBuilder.append(statementElement.getColumn()).append(" ").append(statementElement.getOperator()).append(" ").append("?").append(" ").append(statementElement.getNextStatementRelation());
        }
        ps = connection.getConnection().prepareStatement(stringBuilder.toString());
        updateElements.getStatements().addAll(conditionalElements.getStatements());
        int i = 1;
        for (StatementElement statementElement : updateElements.getStatements()) {
            ps.setString(i, statementElement.getValue());
            ++i;
        }
        return ps;
    }
}

