/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.common.cryptoengineapi.ocsp;

import java.time.ZoneId;
import java.util.Date;
import net.jami.jams.common.cryptoengineapi.ocsp.CertificateSummary;
import net.jami.jams.common.cryptoengineapi.ocsp.RevocationReason;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.UnknownStatus;

public class OCSPCertificateStatusMapper {
    public static CertificateStatus getStatus(CertificateSummary certificateSummary) {
        switch (certificateSummary.getStatus()) {
            case VALID: {
                return CertificateStatus.GOOD;
            }
            case REVOKED: {
                return new RevokedStatus(Date.from(certificateSummary.getRevocationTime().atZone(ZoneId.systemDefault()).toInstant()), RevocationReason.PRIVILEGE_WITHDRAWN.getCode());
            }
            case EXPIRED: {
                return new RevokedStatus(Date.from(certificateSummary.getExpirationTime().atZone(ZoneId.systemDefault()).toInstant()), RevocationReason.SUPERSEDED.getCode());
            }
            case UNKNOWN: {
                return new UnknownStatus();
            }
        }
        throw new IllegalArgumentException("Unknown status! " + certificateSummary.getStatus().name());
    }
}

