/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.ca;

import com.jsoniter.JsonIterator;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import net.jami.jams.ca.workers.crl.CRLWorker;
import net.jami.jams.ca.workers.csr.CertificateWorker;
import net.jami.jams.ca.workers.ocsp.OCSPWorker;
import net.jami.jams.common.cryptoengineapi.CertificateAuthority;
import net.jami.jams.common.cryptoengineapi.CertificateAuthorityConfig;
import net.jami.jams.common.objects.devices.Device;
import net.jami.jams.common.objects.requests.RevocationRequest;
import net.jami.jams.common.objects.system.SystemAccount;
import net.jami.jams.common.objects.user.User;
import net.jami.jams.common.serialization.JsoniterRegistry;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JamsCA
implements CertificateAuthority {
    private static final Logger log = LoggerFactory.getLogger(JamsCA.class);
    private static CRLWorker crlWorker;
    private static OCSPWorker ocspWorker;
    public static volatile String serverDomain;
    public static volatile String signingAlgorithm;
    public static long crlLifetime;
    public static long userLifetime;
    public static long deviceLifetime;
    public static SystemAccount CA;
    public static SystemAccount OCSP;

    @Override
    public void init(String settings, SystemAccount ca, SystemAccount ocsp) {
        CertificateAuthorityConfig config = JsonIterator.deserialize(settings, CertificateAuthorityConfig.class);
        CA = ca;
        OCSP = ocsp;
        serverDomain = config.getServerDomain();
        signingAlgorithm = config.getSigningAlgorithm();
        crlLifetime = config.getCrlLifetime();
        userLifetime = config.getUserLifetime();
        deviceLifetime = config.getDeviceLifetime();
        if (ca != null && ocsp != null) {
            crlWorker = new CRLWorker(CA.getPrivateKey(), CA.getCertificate());
            try {
                ocspWorker = new OCSPWorker(OCSP.getPrivateKey(), OCSP.getCertificate(), crlWorker);
            }
            catch (Exception e) {
                log.error("Could not start OCSP request processor with error {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public User getSignedCertificate(User user) {
        return CertificateWorker.getSignedCertificate(user);
    }

    @Override
    public Device getSignedCertificate(User user, Device device) {
        return CertificateWorker.getSignedCertificate(user, device);
    }

    @Override
    public SystemAccount getSignedCertificate(SystemAccount systemAccount) {
        return CertificateWorker.getSignedCertificate(systemAccount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeCertificate(RevocationRequest revocationRequest) {
        crlWorker.getInput().add(revocationRequest);
        ConcurrentLinkedQueue concurrentLinkedQueue = crlWorker.getInput();
        synchronized (concurrentLinkedQueue) {
            crlWorker.getInput().notify();
        }
    }

    @Override
    public AtomicReference<X509CRLHolder> getLatestCRL() {
        return crlWorker.getExistingCRL();
    }

    @Override
    public String getLatestCRLPEMEncoded() {
        try {
            return Base64.getEncoder().encodeToString(this.getLatestCRL().get().getEncoded());
        }
        catch (Exception e) {
            log.error("Could not return a valid CRL!");
            return null;
        }
    }

    public static OCSPResp getOCSPResponse(OCSPReq ocspRequest) throws OCSPException {
        return ocspWorker.getOCSPResponse(ocspRequest);
    }

    @Override
    public X509Certificate getCA() {
        return CA.getCertificate();
    }

    @Override
    public boolean shutdownThreads() {
        crlWorker.getStop().set(true);
        crlWorker.interrupt();
        Thread.State state = crlWorker.getState();
        while (!state.equals((Object)Thread.State.TERMINATED)) {
            state = crlWorker.getState();
        }
        crlWorker = null;
        ocspWorker.stop();
        return true;
    }

    static {
        signingAlgorithm = "SHA512WITHRSA";
        crlLifetime = 360000000L;
        userLifetime = 360000000L;
        deviceLifetime = 360000000L;
        JsoniterRegistry.initCodecs();
        Security.addProvider(new BouncyCastleProvider());
    }
}

