/*
 * Decompiled with CFR 0.152.
 */
package net.jami.datastore.dao;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.jami.datastore.dao.AbstractDao;
import net.jami.datastore.main.DataStore;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.dao.connectivity.SQLConnection;
import net.jami.jams.common.objects.user.Group;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupDao
extends AbstractDao<Group> {
    private static final Logger log = LoggerFactory.getLogger(GroupDao.class);

    public GroupDao() {
        this.setTableName("groups");
        this.setTClass(Group.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storeObject(Group object) {
        SQLConnection connection = DataStore.connectionPool.getConnection();
        try {
            PreparedStatement ps = connection.getConnection().prepareStatement("INSERT INTO groups (id, name, blueprint) VALUES (?, ?, ?)");
            ps = object.getInsert(ps);
            boolean bl = ps.executeUpdate() != 0;
            return bl;
        }
        catch (SQLException e) {
            log.error("An error has occurred while trying to store a group: " + e.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            DataStore.connectionPool.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateObject(StatementList update, StatementList constraints) {
        String id = update.getStatements().get(0).getValue();
        String name = update.getStatements().get(1).getValue();
        String blueprint = update.getStatements().get(2).getValue();
        SQLConnection connection = DataStore.connectionPool.getConnection();
        try {
            PreparedStatement ps = connection.getConnection().prepareStatement("UPDATE groups SET name = ?, blueprint = ? WHERE id = ?");
            ps.setString(1, name);
            ps.setString(2, blueprint);
            ps.setString(3, id);
            boolean bl = ps.executeUpdate() != 0;
            return bl;
        }
        catch (SQLException e) {
            log.error("An error has occurred while trying to update a group: " + e.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            DataStore.connectionPool.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteObject(StatementList constraints) {
        String id = constraints.getStatements().get(0).getValue();
        SQLConnection connection = DataStore.connectionPool.getConnection();
        try {
            PreparedStatement ps = connection.getConnection().prepareStatement("DELETE FROM groups WHERE id = ?");
            ps.setString(1, id);
            boolean bl = ps.executeUpdate() != 0;
            return bl;
        }
        catch (SQLException e) {
            log.error("An error has occurred while trying to delete a group: " + e.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            DataStore.connectionPool.returnConnection(connection);
        }
    }
}

