/*
 * Decompiled with CFR 0.152.
 */
package net.jami.datastore.dao;

import java.sql.PreparedStatement;
import net.jami.datastore.dao.AbstractDao;
import net.jami.datastore.main.DataStore;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.dao.connectivity.SQLConnection;
import net.jami.jams.common.objects.devices.Device;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceDao
extends AbstractDao<Device> {
    private static final Logger log = LoggerFactory.getLogger(DeviceDao.class);

    public DeviceDao() {
        this.setTableName("devices");
        this.setTClass(Device.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storeObject(Device object) {
        SQLConnection connection = DataStore.connectionPool.getConnection();
        try {
            PreparedStatement ps = connection.getConnection().prepareStatement("INSERT INTO devices (deviceId, owner, displayName, certificate, privatekey) VALUES (?, ?, ?, ?, ?)");
            ps = object.getInsert(ps);
            boolean bl = ps.executeUpdate() != 0;
            return bl;
        }
        catch (Exception e) {
            log.error("An error has occurred while trying to store a user: " + e.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            DataStore.connectionPool.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateObject(StatementList update, StatementList constraints) {
        String deviceName = update.getStatements().get(0).getValue();
        String user = update.getStatements().get(1).getValue();
        String deviceId = update.getStatements().get(2).getValue();
        SQLConnection connection = DataStore.connectionPool.getConnection();
        try {
            PreparedStatement ps = connection.getConnection().prepareStatement("UPDATE devices SET displayName = ? WHERE owner = ? AND deviceId = ?");
            ps.setString(1, deviceName);
            ps.setString(2, user);
            ps.setString(3, deviceId);
            boolean bl = ps.executeUpdate() != 0;
            return bl;
        }
        catch (Exception e) {
            log.error("An error has occurred while trying to update a user: " + e.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            DataStore.connectionPool.returnConnection(connection);
        }
    }
}

