/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.util;

import ezvcard.Messages;
import ezvcard.util.org.apache.commons.codec.binary.Base64;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public final class DataUri {
    private final byte[] data;
    private final String text;
    private final String contentType;

    public DataUri(String contentType, byte[] data) {
        this(contentType, data, null);
    }

    public DataUri(String contentType, String text) {
        this(contentType, null, text);
    }

    public DataUri(String text) {
        this("text/plain", text);
    }

    public DataUri(DataUri original) {
        this(original.contentType, original.data == null ? null : (byte[])original.data.clone(), original.text);
    }

    private DataUri(String contentType, byte[] data, String text) {
        this.contentType = contentType == null ? "" : contentType.toLowerCase();
        this.data = data;
        this.text = text;
    }

    public static DataUri parse(String uri) {
        String scheme = "data:";
        if (uri.length() < scheme.length() || !uri.substring(0, scheme.length()).equalsIgnoreCase(scheme)) {
            throw Messages.INSTANCE.getIllegalArgumentException(18, scheme);
        }
        String contentType = null;
        String charset = null;
        boolean base64 = false;
        String dataStr = null;
        int tokenStart = scheme.length();
        for (int i = scheme.length(); i < uri.length(); ++i) {
            int equals;
            String token;
            char c = uri.charAt(i);
            if (c == ';') {
                token = uri.substring(tokenStart, i);
                if (contentType == null) {
                    contentType = token.toLowerCase();
                } else if (token.toLowerCase().startsWith("charset=")) {
                    equals = token.indexOf(61);
                    charset = token.substring(equals + 1);
                } else if ("base64".equalsIgnoreCase(token)) {
                    base64 = true;
                }
                tokenStart = i + 1;
                continue;
            }
            if (c != ',') continue;
            token = uri.substring(tokenStart, i);
            if (contentType == null) {
                contentType = token.toLowerCase();
            } else if (token.toLowerCase().startsWith("charset=")) {
                equals = token.indexOf(61);
                charset = token.substring(equals + 1);
            } else if ("base64".equalsIgnoreCase(token)) {
                base64 = true;
            }
            dataStr = uri.substring(i + 1);
            break;
        }
        if (dataStr == null) {
            throw Messages.INSTANCE.getIllegalArgumentException(20, new Object[0]);
        }
        String text = null;
        byte[] data = null;
        if (base64) {
            dataStr = dataStr.replaceAll("\\s", "");
            data = Base64.decodeBase64(dataStr);
            if (charset != null) {
                try {
                    text = new String(data, charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException(Messages.INSTANCE.getExceptionMessage(43, charset), e);
                }
                data = null;
            }
        } else {
            text = dataStr;
        }
        return new DataUri(contentType, data, text);
    }

    public byte[] getData() {
        return this.data;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String charset) {
        StringBuilder sb = new StringBuilder();
        sb.append("data:");
        sb.append(this.contentType);
        if (this.data != null) {
            sb.append(";base64,");
            sb.append(Base64.encodeBase64String(this.data));
        } else if (this.text != null) {
            if (charset == null) {
                sb.append(',').append(this.text);
            } else {
                byte[] data;
                try {
                    data = this.text.getBytes(charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException(Messages.INSTANCE.getExceptionMessage(44, charset), e);
                }
                sb.append(";charset=").append(charset);
                sb.append(";base64,");
                sb.append(Base64.encodeBase64String(data));
            }
        } else {
            sb.append(',');
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.contentType.hashCode();
        result = 31 * result + Arrays.hashCode(this.data);
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataUri other = (DataUri)obj;
        if (!this.contentType.equals(other.contentType)) {
            return false;
        }
        if (!Arrays.equals(this.data, other.data)) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }
}

