/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.property;

import ezvcard.SupportedVersions;
import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.ValidationWarning;
import ezvcard.parameter.Pid;
import ezvcard.parameter.RelatedType;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.HasAltId;
import ezvcard.property.VCardProperty;
import ezvcard.util.TelUri;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedVersions(value={VCardVersion.V4_0})
public class Related
extends VCardProperty
implements HasAltId {
    private String uri;
    private String text;

    public Related() {
    }

    public Related(String uri) {
        this.setUri(uri);
    }

    public Related(Related original) {
        super(original);
        this.uri = original.uri;
        this.text = original.text;
    }

    public static Related email(String email) {
        return new Related("mailto:" + email);
    }

    public static Related im(String protocol, String handle) {
        return new Related(protocol + ":" + handle);
    }

    public static Related telephone(TelUri telUri) {
        return new Related(telUri.toString());
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
        this.text = null;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.uri = null;
    }

    public List<RelatedType> getTypes() {
        return new VCardParameters.TypeParameterList<RelatedType>(this.parameters){

            @Override
            protected RelatedType _asObject(String value) {
                return RelatedType.get(value);
            }
        };
    }

    @Override
    public List<Pid> getPids() {
        return super.getPids();
    }

    @Override
    public Integer getPref() {
        return super.getPref();
    }

    @Override
    public void setPref(Integer pref) {
        super.setPref(pref);
    }

    @Override
    public String getAltId() {
        return this.parameters.getAltId();
    }

    @Override
    public void setAltId(String altId) {
        this.parameters.setAltId(altId);
    }

    @Override
    protected void _validate(List<ValidationWarning> warnings, VCardVersion version, VCard vcard) {
        if (this.uri == null && this.text == null) {
            warnings.add(new ValidationWarning(8, new Object[0]));
        }
    }

    @Override
    protected Map<String, Object> toStringValues() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("uri", this.uri);
        values.put("text", this.text);
        return values;
    }

    @Override
    public Related copy() {
        return new Related(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Related other = (Related)obj;
        if (this.text == null ? other.text != null : !this.text.equals(other.text)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }
}

