/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.property;

import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.ValidationWarning;
import ezvcard.property.HasAltId;
import ezvcard.property.VCardProperty;
import ezvcard.util.GeoUri;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaceProperty
extends VCardProperty
implements HasAltId {
    protected GeoUri geoUri;
    protected String uri;
    protected String text;

    public PlaceProperty() {
    }

    public PlaceProperty(double latitude, double longitude) {
        this.setCoordinates(latitude, longitude);
    }

    public PlaceProperty(String text) {
        this.setText(text);
    }

    public PlaceProperty(PlaceProperty original) {
        super(original);
        this.geoUri = original.geoUri;
        this.uri = original.uri;
        this.text = original.text;
    }

    public Double getLatitude() {
        return this.geoUri == null ? null : this.geoUri.getCoordA();
    }

    public Double getLongitude() {
        return this.geoUri == null ? null : this.geoUri.getCoordB();
    }

    public GeoUri getGeoUri() {
        return this.geoUri;
    }

    public void setCoordinates(double latitude, double longitude) {
        this.setGeoUri(new GeoUri.Builder(latitude, longitude).build());
    }

    public void setGeoUri(GeoUri geoUri) {
        this.geoUri = geoUri;
        this.uri = null;
        this.text = null;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
        this.geoUri = null;
        this.text = null;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.geoUri = null;
        this.uri = null;
    }

    @Override
    public String getAltId() {
        return this.parameters.getAltId();
    }

    @Override
    public void setAltId(String altId) {
        this.parameters.setAltId(altId);
    }

    @Override
    public String getLanguage() {
        return super.getLanguage();
    }

    @Override
    public void setLanguage(String language) {
        super.setLanguage(language);
    }

    @Override
    protected void _validate(List<ValidationWarning> warnings, VCardVersion version, VCard vcard) {
        if (this.uri == null && this.text == null && this.geoUri == null) {
            warnings.add(new ValidationWarning(8, new Object[0]));
        }
    }

    @Override
    protected Map<String, Object> toStringValues() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("geoUri", this.geoUri);
        values.put("uri", this.uri);
        values.put("text", this.text);
        return values;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.geoUri == null ? 0 : this.geoUri.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        PlaceProperty other = (PlaceProperty)obj;
        if (this.geoUri == null ? other.geoUri != null : !this.geoUri.equals(other.geoUri)) {
            return false;
        }
        if (this.text == null ? other.text != null : !this.text.equals(other.text)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }
}

