/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.update;

import com.jsoniter.JsonIterator;
import com.jsoniter.any.Any;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.TimerTask;
import javax.net.ssl.SSLContext;
import net.jami.jams.common.updater.FileDescription;
import net.jami.jams.common.utils.VersioningUtils;
import net.jami.jams.common.utils.X509Utils;
import net.jami.jams.server.update.JAMSUpdater;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCheckTask
extends TimerTask {
    private static final Logger log = LoggerFactory.getLogger(UpdateCheckTask.class);
    private HashMap<String, FileDescription> remoteData = new HashMap();
    private HashMap<String, FileDescription> localData = new HashMap();
    private SSLContext sslContext;
    private volatile KeyStore trustStore;
    protected static volatile String UPDATE_SERVER_URI;

    protected UpdateCheckTask() {
        try {
            InputStream is = UpdateCheckTask.class.getClassLoader().getResourceAsStream("oem/ca.crt");
            X509Certificate certificate = X509Utils.getCertificateFromPEMString((String)new String(is.readAllBytes()));
            this.trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            this.trustStore.load(null, null);
            this.trustStore.setCertificateEntry("ca", certificate);
            this.sslContext = SSLContexts.custom().loadTrustMaterial(this.trustStore, null).build();
            InputStream input = this.getClass().getClassLoader().getResourceAsStream("oem/config.json");
            Any any = JsonIterator.deserialize(input.readAllBytes());
            UPDATE_SERVER_URI = any.get((Object)"UPDATE_URL").toString();
        }
        catch (Exception e) {
            log.error("Could not initialize the trust store with error {}", (Object)e.getMessage());
        }
    }

    @Override
    public void run() {
        try {
            this.localData = VersioningUtils.checkVersion(null);
            this.getLatestVersion();
            this.localData.forEach((k, v) -> {
                if (this.remoteData.containsKey(k) && this.remoteData.get(k).compareTo(v) > 0) {
                    log.info("Detected a new version on SFL servers!");
                    JAMSUpdater.updateAvailable.set(true);
                }
            });
        }
        catch (Exception e) {
            log.error("Could not check for updates with error: {}", (Object)e.getMessage());
        }
    }

    private void getLatestVersion() {
        try {
            CloseableHttpClient httpClient = HttpClients.custom().setSSLContext(this.sslContext).build();
            HttpResponse response = httpClient.execute(new HttpGet(UPDATE_SERVER_URI + "/versions.json"));
            Any any = JsonIterator.deserialize(response.getEntity().getContent().readAllBytes());
            any.asMap().forEach((k, v) -> this.remoteData.put(v.get((Object)"filename").toString(), new FileDescription(v.get((Object)"filename").toString(), v.get((Object)"version").toString(), v.get((Object)"md5").toString(), k)));
        }
        catch (Exception e) {
            log.warn("Could not establish connection to JAMS Update Center with error: " + e.toString());
        }
    }

    public HashMap<String, FileDescription> getRemoteData() {
        return this.remoteData;
    }

    public HashMap<String, FileDescription> getLocalData() {
        return this.localData;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    public void setRemoteData(HashMap<String, FileDescription> remoteData) {
        this.remoteData = remoteData;
    }

    public void setLocalData(HashMap<String, FileDescription> localData) {
        this.localData = localData;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setTrustStore(KeyStore trustStore) {
        this.trustStore = trustStore;
    }
}

