/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.auth.login;

import java.security.cert.X509Certificate;
import net.jami.jams.common.authmodule.AuthTokenResponse;
import net.jami.jams.server.Server;
import net.jami.jams.server.servlets.api.auth.login.Decoders;
import org.bouncycastle.cert.X509CRLHolder;

public class AuthRequestProcessor {
    public static AuthTokenResponse processX509Auth(X509Certificate[] certificates) {
        return Server.userAuthenticationModule.authenticateUser(certificates, (X509CRLHolder)Server.certificateAuthority.getLatestCRL().get(), Server.certificateAuthority.getCA());
    }

    public static AuthTokenResponse processUsernamePasswordAuth(String username, String password) {
        return Server.userAuthenticationModule.authenticateUser(username, password);
    }

    public static AuthTokenResponse processUsernamePasswordAuth(String authorization) {
        String[] credentials = Decoders.decodeAuthHeader(authorization);
        if (credentials != null && credentials.length == 2) {
            return Server.userAuthenticationModule.authenticateUser(credentials[0], credentials[1]);
        }
        return null;
    }
}

