/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.auth.device;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.jsoniter.JsonIterator;
import com.jsoniter.output.JsonStream;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import net.jami.jams.common.dao.StatementElement;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.objects.devices.Device;
import net.jami.jams.common.objects.requests.DeviceRegistrationRequest;
import net.jami.jams.common.objects.responses.DeviceRegistrationResponse;
import net.jami.jams.common.objects.responses.DeviceRevocationResponse;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import net.jami.jams.server.core.workflows.RegisterDeviceFlow;
import net.jami.jams.server.core.workflows.RevokeDeviceFlow;
import org.bouncycastle.cert.X509CRLHolder;

@WebServlet(value={"/api/auth/device/*"})
public class DeviceServlet
extends HttpServlet {
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String username = req.getAttribute("username").toString();
        String deviceId = req.getPathInfo().replace("/", "");
        StatementList statementList = new StatementList();
        StatementElement st1 = new StatementElement("owner", "=", username, "AND");
        StatementElement st2 = new StatementElement("deviceId", "=", deviceId, "");
        statementList.addStatement(st1);
        statementList.addStatement(st2);
        Device device = (Device)Server.dataStore.getDeviceDao().getObjects(statementList).get(0);
        if (Server.certificateAuthority.getLatestCRL().get() != null) {
            device.setRevoked(Boolean.valueOf(((X509CRLHolder)Server.certificateAuthority.getLatestCRL().get()).getRevokedCertificate(device.getCertificate().getSerialNumber()) != null));
        } else {
            device.setRevoked(Boolean.valueOf(false));
        }
        resp.getOutputStream().write(JsonStream.serialize(device).getBytes());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"USER")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        DeviceRegistrationRequest request = JsonIterator.deserialize(req.getInputStream().readAllBytes(), DeviceRegistrationRequest.class);
        DeviceRegistrationResponse devResponse = RegisterDeviceFlow.registerDevice(req.getAttribute("username").toString(), request);
        if (devResponse != null) {
            Gson gson = new Gson();
            String filteredJson = gson.toJson(devResponse);
            JsonObject obj = gson.fromJson(filteredJson, JsonObject.class);
            if (obj.get("videoEnabled") != null) {
                obj.add("Account.videoEnabled", obj.get("videoEnabled"));
                obj.remove("videoEnabled");
            }
            if (obj.get("publicInCalls") != null) {
                obj.add("DHT.PublicInCalls", obj.get("publicInCalls"));
                obj.remove("publicInCalls");
            }
            if (obj.get("autoAnswer") != null) {
                obj.add("Account.autoAnswer", obj.get("autoAnswer"));
                obj.remove("autoAnswer");
            }
            if (obj.get("peerDiscovery") != null) {
                obj.add("Account.peerDiscovery", obj.get("peerDiscovery"));
                obj.remove("peerDiscovery");
            }
            if (obj.get("accountDiscovery") != null) {
                obj.add("Account.accountDiscovery", obj.get("accountDiscovery"));
                obj.remove("accountDiscovery");
            }
            if (obj.get("accountPublish") != null) {
                obj.add("Account.accountPublish", obj.get("accountPublish"));
                obj.remove("accountPublish");
            }
            if (obj.get("rendezVous") != null) {
                obj.add("Account.rendezVous", obj.get("rendezVous"));
                obj.remove("rendezVous");
            }
            if (obj.get("upnpEnabled") != null) {
                obj.add("Account.upnpEnabled", obj.get("upnpEnabled"));
                obj.remove("upnpEnabled");
            }
            if (obj.get("turnEnabled") != null) {
                obj.add("TURN.enable", obj.get("turnEnabled"));
                obj.remove("turnEnabled");
            }
            if (obj.get("turnServer") != null) {
                obj.add("TURN.server", obj.get("turnServer"));
                obj.remove("turnServer");
            }
            if (obj.get("turnServerUserName") != null) {
                obj.add("TURN.username", obj.get("turnServerUserName"));
                obj.remove("turnServerUserName");
            }
            if (obj.get("turnServerPassword") != null) {
                obj.add("TURN.password", obj.get("turnServerPassword"));
                obj.remove("turnServerPassword");
            }
            if (obj.get("proxyEnabled") != null) {
                obj.add("Account.proxyEnabled", obj.get("proxyEnabled"));
                obj.remove("proxyEnabled");
            }
            if (obj.get("proxyServer") != null) {
                obj.add("Account.proxyServer", obj.get("proxyServer"));
                obj.remove("proxyServer");
            }
            if (obj.get("dhtProxyListUrl") != null) {
                obj.add("Account.dhtProxyListUrl", obj.get("dhtProxyListUrl"));
                obj.remove("dhtProxyListUrl");
            }
            if (obj.get("displayName") != null) {
                obj.add("Account.displayName", obj.get("displayName"));
                obj.remove("displayName");
            }
            resp.getOutputStream().write(obj.toString().getBytes());
        } else {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)500, (String)"could not enroll a device due to server-side error");
        }
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String username = req.getAttribute("username").toString();
        String deviceId = req.getPathInfo().replace("/", "");
        String deviceName = req.getParameter("deviceName");
        StatementList update = new StatementList();
        StatementElement st0 = new StatementElement("deviceName", "=", deviceName, "");
        update.addStatement(st0);
        StatementList constraint = new StatementList();
        StatementElement st1 = new StatementElement("owner", "=", username, "AND");
        StatementElement st2 = new StatementElement("deviceId", "=", deviceId, "");
        update.addStatement(st1);
        update.addStatement(st2);
        if (Server.dataStore.getDeviceDao().updateObject(update, constraint)) {
            resp.setStatus(200);
        } else {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)500, (String)"could not update device information due to server-side error");
        }
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"USER")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String deviceId = req.getPathInfo().replace("/", "");
        StatementList statementList = new StatementList();
        StatementElement statementElement = new StatementElement("owner", "=", req.getAttribute("username").toString(), "");
        statementList.addStatement(statementElement);
        if (Server.dataStore.getDeviceDao().getObjects(statementList).stream().filter(device -> device.getDeviceId().equals(deviceId)).count() == 0L) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient rights to revoke this device!");
            return;
        }
        DeviceRevocationResponse devResponse = RevokeDeviceFlow.revokeDevice(req.getAttribute("username").toString(), deviceId);
        if (devResponse != null) {
            resp.getOutputStream().write(JsonStream.serialize(devResponse).getBytes());
        } else {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)500, (String)"could not revoke device due to server-side error");
        }
    }
}

