/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.admin.group;

import com.jsoniter.output.JsonStream;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.stream.Collectors;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.dao.StatementElement;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.objects.user.Group;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/admin/group/*"})
public class GroupServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(GroupServlet.class);

    @Override
    @JsonContent
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        Group singleGroup = null;
        String id = req.getPathInfo().replace("/", "");
        StatementList statementList = new StatementList();
        StatementElement st = new StatementElement("id", "=", id, "");
        statementList.addStatement(st);
        if (!Server.dataStore.getGroupDao().getObjects(statementList).isEmpty()) {
            singleGroup = (Group)Server.dataStore.getGroupDao().getObjects(statementList).get(0);
        }
        if (singleGroup != null) {
            resp.getOutputStream().write(JsonStream.serialize(singleGroup).getBytes());
            resp.setStatus(200);
        } else {
            log.info("No group with this id was found!");
            resp.setStatus(404);
        }
    }

    @Override
    @JsonContent
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String id = req.getPathInfo().replace("/", "");
        JSONObject obj = new JSONObject(req.getReader().lines().collect(Collectors.joining(System.lineSeparator())));
        String name = obj.getString("name");
        String blueprint = obj.getString("blueprint");
        StatementList update = new StatementList();
        StatementElement st0 = new StatementElement("id", "=", id, "");
        update.addStatement(st0);
        StatementElement st1 = new StatementElement("name", "=", name, "");
        update.addStatement(st1);
        StatementElement st2 = new StatementElement("blueprint", "=", blueprint, "");
        update.addStatement(st2);
        StatementList constraint = new StatementList();
        if (Server.dataStore.getGroupDao().updateObject(update, constraint)) {
            resp.setStatus(200);
        } else {
            resp.sendError(500, "Could not update group!");
        }
    }

    @Override
    @JsonContent
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String id = req.getPathInfo().replace("/", "");
        StatementElement statementElement = new StatementElement("id", "=", id, "");
        StatementList constraint = new StatementList();
        constraint.addStatement(statementElement);
        if (Server.dataStore.getGroupDao().deleteObject(constraint)) {
            StatementElement statementElement1 = new StatementElement("username", "=", "*", "");
            StatementElement statementElement2 = new StatementElement("groupId", "=", id, "");
            StatementList constraintMapping = new StatementList();
            constraintMapping.addStatement(statementElement1);
            constraintMapping.addStatement(statementElement2);
            if (Server.dataStore.getUserGroupMappingsDao().deleteObject(constraintMapping)) {
                resp.setStatus(200);
            } else {
                resp.sendError(500, "Could not delete the group mappings successfully!");
            }
        } else {
            resp.sendError(500, "Could not delete the group successfully!");
        }
    }
}

