/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.admin.directory;

import com.jsoniter.JsonIterator;
import com.jsoniter.output.JsonStream;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Scanner;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.authentication.AuthenticationSource;
import net.jami.jams.common.authentication.AuthenticationSourceType;
import net.jami.jams.common.authmodule.AuthModuleKey;
import net.jami.jams.common.dao.StatementElement;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.objects.user.User;
import net.jami.jams.common.objects.user.UserProfile;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/admin/directory/entry"})
public class DirectoryEntryServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(DirectoryEntryServlet.class);

    @Override
    @JsonContent
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String realm = "LOCAL";
        Scanner s = new Scanner(req.getInputStream()).useDelimiter("\\A");
        String result = s.hasNext() ? s.next() : "";
        JSONObject obj = new JSONObject(result);
        UserProfile userProfile = new UserProfile();
        userProfile.setUsername(obj.get("username").toString());
        userProfile.setFirstName(obj.get("firstName").toString());
        userProfile.setLastName(obj.get("lastName").toString());
        userProfile.setEmail(obj.get("email").toString());
        userProfile.setProfilePicture(obj.get("profilePicture").toString());
        userProfile.setOrganization(obj.get("organization").toString());
        userProfile.setPhoneNumber(obj.get("phoneNumber").toString());
        userProfile.setPhoneNumberExtension(obj.get("phoneNumberExtension").toString());
        userProfile.setFaxNumber(obj.get("faxNumber").toString());
        userProfile.setMobileNumber(obj.get("mobileNumber").toString());
        userProfile.setId(obj.get("jamiId").toString());
        ((AuthenticationSource)Server.userAuthenticationModule.getAuthSources().get(new AuthModuleKey(realm, AuthenticationSourceType.LOCAL))).setUserProfile(userProfile);
        resp.setStatus(200);
        HashMap<String, String> profileName = new HashMap<String, String>();
        profileName.put("username", userProfile.getUsername());
        resp.getOutputStream().write(JsonStream.serialize(profileName).getBytes());
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException, SecurityException {
        UserProfile userProfile = JsonIterator.deserialize(req.getInputStream().readAllBytes(), UserProfile.class);
        StatementList select = new StatementList();
        StatementElement st = new StatementElement("username", "=", userProfile.getUsername(), "");
        select.addStatement(st);
        User targetUser = (User)Server.dataStore.getUserDao().getObjects(select).get(0);
        select = new StatementList();
        st = new StatementElement("username", "=", req.getAttribute("username").toString(), "");
        select.addStatement(st);
        User callingUser = (User)Server.dataStore.getUserDao().getObjects(select).get(0);
        if (targetUser.getUserType() != AuthenticationSourceType.LOCAL) {
            resp.sendError(403, "The user is not a local user, therefore we cannot change his data!");
            return;
        }
        if (callingUser.getAccessLevel() == AccessLevel.ADMIN || callingUser.getAccessLevel() == AccessLevel.USER && callingUser.getUsername().equals(targetUser.getUsername())) {
            select = new StatementList();
            select.addStatement(new StatementElement("username", "=", userProfile.getUsername(), ""));
            if (Server.dataStore.updateUserProfile(userProfile)) {
                resp.setStatus(200);
            } else {
                resp.sendError(500, "Could not update the users's profile information");
            }
        } else {
            resp.sendError(403, "The user is either not an admin account or is attempting to edit a profile that is not his own!");
            return;
        }
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
    }
}

