/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.admin.devices;

import com.jsoniter.output.JsonStream;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.dao.StatementElement;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.objects.devices.Device;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import org.bouncycastle.cert.X509CRLHolder;

@WebServlet(value={"/api/admin/devices"})
public class DevicesServlet
extends HttpServlet {
    @Override
    @JsonContent
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String username = req.getParameter("username");
        StatementList statementList = new StatementList();
        statementList.addStatement(new StatementElement("owner", "=", username, ""));
        List<Device> devices = Server.dataStore.getDeviceDao().getObjects(statementList);
        if (Server.certificateAuthority.getLatestCRL() != null) {
            devices.forEach(device -> device.setRevoked(Boolean.valueOf(((X509CRLHolder)Server.certificateAuthority.getLatestCRL().get()).getRevokedCertificate(device.getCertificate().getSerialNumber()) != null)));
        } else {
            devices.forEach(device -> device.setRevoked(Boolean.valueOf(false)));
        }
        resp.getOutputStream().write(JsonStream.serialize(devices).getBytes());
    }
}

