/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.admin.contacts;

import com.jsoniter.JsonIterator;
import com.jsoniter.output.JsonStream;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.dao.StatementElement;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.objects.contacts.Contact;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.common.utils.ContactMerger;
import net.jami.jams.server.Server;
import org.json.JSONObject;

@WebServlet(value={"/api/admin/contacts"})
public class ContactServlet
extends HttpServlet {
    @Override
    @JsonContent
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        StatementList statementList = new StatementList();
        statementList.addStatement(new StatementElement("owner", "=", req.getParameter("username").toString(), ""));
        List contactList = Server.dataStore.getContactDao().getObjects(statementList);
        resp.getOutputStream().write(JsonStream.serialize(contactList).getBytes());
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        Scanner s = new Scanner(req.getInputStream()).useDelimiter("\\A");
        String res = s.hasNext() ? s.next() : "";
        JSONObject obj = new JSONObject(res);
        Contact contact = new Contact();
        contact.setDisplayName(obj.get("displayName").toString());
        contact.setTimestamp(Long.valueOf(System.currentTimeMillis() / 1000L));
        contact.setStatus(Character.valueOf('A'));
        contact.setOwner(req.getParameter("username"));
        contact.setUri(obj.get("uri").toString());
        StatementList statementList = new StatementList();
        statementList.addStatement(new StatementElement("owner", "=", req.getParameter("username").toString(), ""));
        List localList = Server.dataStore.getContactDao().getObjects(statementList);
        ArrayList<Contact> remoteList = new ArrayList<Contact>();
        remoteList.add(contact);
        List result = ContactMerger.mergeContacts(localList, remoteList);
        if (Server.dataStore.getContactDao().storeContactList(result)) {
            resp.setStatus(200);
        } else {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)500, (String)"could not store a contact due to server-side error");
        }
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        StatementList statementList = new StatementList();
        statementList.addStatement(new StatementElement("owner", "=", req.getParameter("username").toString(), "AND"));
        statementList.addStatement(new StatementElement("uri", "=", req.getParameter("uri"), ""));
        if (Server.dataStore.getContactDao().deleteObject(statementList)) {
            resp.setStatus(200);
        } else {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)500, (String)"could not delete a contact due to server-side error");
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        StatementList statementList = new StatementList();
        statementList.addStatement(new StatementElement("owner", "=", req.getParameter("username").toString(), ""));
        List localList = Server.dataStore.getContactDao().getObjects(statementList);
        List<Contact> remoteList = Arrays.asList(JsonIterator.deserialize(req.getInputStream().readAllBytes(), Contact[].class));
        remoteList.forEach(contact -> contact.setOwner(req.getParameter("username").toString()));
        List result = ContactMerger.mergeContacts(localList, remoteList);
        if (!Server.dataStore.getContactDao().storeContactList(result)) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)500, (String)"Could not store contacts!");
        } else {
            resp.getOutputStream().write(JsonStream.serialize(result).getBytes());
        }
    }
}

