/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets;

import com.jsoniter.JsonIterator;
import com.jsoniter.output.JsonStream;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.cert.X509Certificate;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.authmodule.AuthTokenResponse;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.servlets.api.auth.login.AuthRequestProcessor;
import net.jami.jams.server.servlets.api.auth.login.LoginRequest;

@WebServlet(value={"/api/login"})
public class LoginServlet
extends HttpServlet {
    @Override
    @JsonContent
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        AuthTokenResponse res = null;
        if (req.getHeader("authorization") != null) {
            res = AuthRequestProcessor.processUsernamePasswordAuth(req.getHeader("authorization"));
        } else if (req.getAttribute("jakarta.servlet.request.X509Certificate") != null) {
            res = AuthRequestProcessor.processX509Auth((X509Certificate[])req.getAttribute("jakarta.servlet.request.X509Certificate"));
        } else {
            LoginRequest object = JsonIterator.deserialize(req.getInputStream().readAllBytes(), LoginRequest.class);
            if (object.getUsername() != null && object.getPassword() != null) {
                res = AuthRequestProcessor.processUsernamePasswordAuth(object.getUsername(), object.getPassword());
            }
        }
        if (res == null) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)401, (String)"Invalid credentials provided!");
        } else {
            resp.getOutputStream().write(JsonStream.serialize(res).getBytes());
        }
    }
}

