/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.core.workflows;

import com.jsoniter.output.JsonStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import net.jami.jams.common.authentication.AuthenticationSourceType;
import net.jami.jams.common.objects.roots.X509Fields;
import net.jami.jams.common.objects.system.SystemAccount;
import net.jami.jams.common.objects.system.SystemAccountType;
import net.jami.jams.common.server.ServerSettings;
import net.jami.jams.nameserver.LocalNameServer;
import net.jami.jams.nameserver.PublicNameServer;
import net.jami.jams.server.Server;
import net.jami.jams.server.servlets.api.install.CachedObjects;
import net.jami.jams.server.startup.AuthModuleLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallationFinalizer {
    private static final Logger log = LoggerFactory.getLogger(InstallationFinalizer.class);
    private boolean useLocalNS = true;

    public boolean finalizeInstallation() {
        try {
            log.info("Building configuration from submitted variables...");
            ServerSettings serverSettings = new ServerSettings();
            serverSettings.setCaConfiguration(JsonStream.serialize(CachedObjects.certificateAuthorityConfig));
            serverSettings.setServerPublicURI(CachedObjects.certificateAuthorityConfig.getServerDomain());
            if (CachedObjects.activeDirectorySettings != null) {
                serverSettings.setActiveDirectoryConfiguration(JsonStream.serialize(CachedObjects.activeDirectorySettings));
                log.info("Server configured to use Active Directory as the authentication backend!");
            }
            if (CachedObjects.ldapSettings != null) {
                serverSettings.setLdapConfiguration(JsonStream.serialize(CachedObjects.ldapSettings));
                log.info("Server configured to use LDAP as the authentication backend!");
            }
            if (CachedObjects.localAuthSettings != null) {
                serverSettings.setLocalDirectoryConfiguration(JsonStream.serialize(CachedObjects.localAuthSettings));
                if (CachedObjects.localAuthSettings.getPublicNames().booleanValue()) {
                    this.useLocalNS = false;
                    Server.nameServer = new PublicNameServer(CachedObjects.localAuthSettings.getPublicNameServer());
                    log.warn("Server configured to use {} as the nameserver for Jami clients !", (Object)CachedObjects.localAuthSettings.getPublicNameServer());
                }
                log.info("Server is configured to use local authentication engine");
            }
            FileOutputStream os = new FileOutputStream(new File("config.json"));
            ((OutputStream)os).write(JsonStream.serialize(serverSettings).getBytes());
            os.flush();
            ((OutputStream)os).close();
            log.info("Settings succesfully saved to configuration file...");
            log.info("Attempting to save the CA and generate the OCSP certificate...");
            if (CachedObjects.createCARequest.getFields() != null) {
                SystemAccount caAccount = new SystemAccount();
                caAccount.setSystemAccountType(SystemAccountType.CA);
                caAccount.setX509Fields(CachedObjects.createCARequest.getFields());
                Server.certificateAuthority.getSignedCertificate(caAccount);
                Server.dataStore.getSystemDao().storeObject(caAccount);
                log.info("Succesfully stored CA");
                Server.certificateAuthority.init(serverSettings.getCaConfiguration(), caAccount, null);
                SystemAccount ocspAccount = new SystemAccount();
                ocspAccount.setX509Fields(new X509Fields());
                ocspAccount.getX509Fields().setCommonName("OCSP Server Certificate");
                ocspAccount.setSystemAccountType(SystemAccountType.OCSP);
                ocspAccount.getX509Fields().setLifetime(caAccount.getX509Fields().getLifetime());
                Server.certificateAuthority.getSignedCertificate(ocspAccount);
                Server.dataStore.getSystemDao().storeObject(ocspAccount);
                log.info("Successfully created and stored the OCSP certificate");
                Server.certificateAuthority.init(serverSettings.getCaConfiguration(), caAccount, ocspAccount);
                log.info("Succesfully inited the certificate authority with the appropriate settings...");
            }
            log.info("Initializing the selected authentication providers");
            Server.userAuthenticationModule = AuthModuleLoader.loadAuthenticationModule(Server.dataStore, Server.certificateAuthority);
            if (serverSettings.getActiveDirectoryConfiguration() != null) {
                Server.userAuthenticationModule.attachAuthSource(AuthenticationSourceType.AD, serverSettings.getActiveDirectoryConfiguration());
            }
            if (serverSettings.getLdapConfiguration() != null) {
                Server.userAuthenticationModule.attachAuthSource(AuthenticationSourceType.LDAP, serverSettings.getLdapConfiguration());
            }
            if (this.useLocalNS) {
                Server.nameServer = new LocalNameServer(Server.dataStore, Server.userAuthenticationModule, serverSettings.getServerPublicURI());
            }
            log.info("Building keystore for client auth for tomcat...");
            KeyStore ks = KeyStore.getInstance("JKS");
            char[] password = "changeit".toCharArray();
            ks.load(null, password);
            ks.setCertificateEntry("jams-ca", Server.certificateAuthority.getCA());
            FileOutputStream fos = new FileOutputStream("keystore.jks");
            ks.store(fos, password);
            fos.close();
            log.info("Successfully built keystore for for tomcat!");
            Server.isInstalled.set(true);
            Server.tomcatLauncher.swapConnectors();
            log.info("The installation has completed successfully, you can now use JAMS!");
        }
        catch (Exception e) {
            log.error("Could not save settings to disk with error: " + e.toString());
            return false;
        }
        return true;
    }
}

