/*
 * Decompiled with CFR 0.152.
 */
package net.jami.datastore.dao;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.jami.datastore.dao.AbstractDao;
import net.jami.datastore.main.DataStore;
import net.jami.jams.common.dao.StatementElement;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.dao.connectivity.SQLConnection;
import net.jami.jams.common.objects.user.UserGroupMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserGroupMappingsDao
extends AbstractDao<UserGroupMapping> {
    private static final Logger log = LoggerFactory.getLogger(UserGroupMappingsDao.class);

    public UserGroupMappingsDao() {
        this.setTableName("usergroupmappings");
        this.setTClass(UserGroupMapping.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storeObject(UserGroupMapping object) {
        SQLConnection connection = DataStore.connectionPool.getConnection();
        try {
            PreparedStatement ps = connection.getConnection().prepareStatement("INSERT INTO usergroupmappings (username, groupId) VALUES (?,?)");
            ps = object.getInsert(ps);
            boolean bl = ps.executeUpdate() != 0;
            return bl;
        }
        catch (Exception e) {
            log.error("An error has occurred while trying to store a user profile: " + e.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            DataStore.connectionPool.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteObject(StatementList constraints) {
        String username = ((StatementElement)constraints.getStatements().get(0)).getValue();
        String groupId = ((StatementElement)constraints.getStatements().get(1)).getValue();
        SQLConnection connection = DataStore.connectionPool.getConnection();
        try {
            if (username.equals("*")) {
                PreparedStatement ps = connection.getConnection().prepareStatement("DELETE FROM usergroupmappings WHERE groupId = ?");
                ps.setString(1, groupId);
                boolean bl = ps.executeUpdate() != 0;
                return bl;
            }
            PreparedStatement ps = connection.getConnection().prepareStatement("DELETE FROM usergroupmappings WHERE username = ? AND groupId = ?");
            ps.setString(1, username);
            ps.setString(2, groupId);
            boolean bl = ps.executeUpdate() != 0;
            return bl;
        }
        catch (SQLException e) {
            log.error("An error has occurred while trying to delete a group member: " + e.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            DataStore.connectionPool.returnConnection(connection);
        }
    }
}

