/*
 * Decompiled with CFR 0.152.
 */
package net.jami.datastore.dao;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import net.jami.datastore.main.DataStore;
import net.jami.jams.common.dao.DeleteStatementBuilder;
import net.jami.jams.common.dao.SelectStatementBuilder;
import net.jami.jams.common.dao.StatementConstraints;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.dao.UpdateStatementBuilder;
import net.jami.jams.common.dao.connectivity.SQLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDao<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractDao.class);
    private String tableName;
    private Class<T> tClass;

    public abstract boolean storeObject(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getObjects(StatementList constraints) {
        ArrayList<T> result = new ArrayList<T>();
        SQLConnection connection = DataStore.connectionPool.getConnection();
        try {
            PreparedStatement ps = SelectStatementBuilder.buildStatement((String)this.tableName, (StatementList)constraints, null, (SQLConnection)connection);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.tClass.getConstructor(ResultSet.class).newInstance(rs));
            }
            ArrayList<T> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            log.error("An error has occurred while trying to fetch an object: " + e.toString());
            List<T> list = null;
            return list;
        }
        finally {
            DataStore.connectionPool.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getObjects(StatementList constraints, StatementConstraints statementConstraints) {
        ArrayList<T> result = new ArrayList<T>();
        SQLConnection connection = DataStore.connectionPool.getConnection();
        try {
            PreparedStatement ps = SelectStatementBuilder.buildStatement((String)this.tableName, (StatementList)constraints, (StatementConstraints)statementConstraints, (SQLConnection)connection);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.tClass.getConstructor(ResultSet.class).newInstance(rs));
            }
            ArrayList<T> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            log.error("An error has occurred while trying to fetch a device: " + e.toString());
            List<T> list = null;
            return list;
        }
        finally {
            DataStore.connectionPool.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateObject(StatementList update, StatementList constraints) {
        SQLConnection connection = DataStore.connectionPool.getConnection();
        try {
            PreparedStatement ps = UpdateStatementBuilder.buildStatement((String)this.tableName, (StatementList)update, (StatementList)constraints, (SQLConnection)connection);
            boolean bl = ps.execute();
            return bl;
        }
        catch (Exception e) {
            log.error("An error has occurred while trying to fetch a device: " + e.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            DataStore.connectionPool.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteObject(StatementList delete) {
        SQLConnection connection = DataStore.connectionPool.getConnection();
        try {
            PreparedStatement ps = DeleteStatementBuilder.buildStatement((String)this.tableName, (StatementList)delete, (SQLConnection)connection);
            boolean bl = ps.executeUpdate() != 0;
            return bl;
        }
        catch (Exception e) {
            log.error("An error has occurred while trying to fetch a device: " + e.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            DataStore.connectionPool.returnConnection(connection);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Class<T> getTClass() {
        return this.tClass;
    }

    public void setTClass(Class<T> tClass) {
        this.tClass = tClass;
    }
}

